/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ibatis.javassist.util.proxy.ProxyObject;

public class ClassUtil {
    private static final String[] OBJECT_METHODS = new String[]{"toString", "getClass", "equals", "hashCode", "wait", "notify", "notifyAll", "clone", "finalize"};
    private static final List<String> PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    private static final String ENHANCER_BY = "$$EnhancerBy";
    private static final String JAVASSIST_BY = "_$$_";

    private ClassUtil() {
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> cls : clazz.getInterfaces()) {
            if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
            return true;
        }
        return Proxy.isProxyClass(clazz);
    }

    public static <T> Class<T> getUsefulClass(Class<T> clazz) {
        if (ProxyObject.class.isAssignableFrom(clazz)) {
            return clazz.getSuperclass();
        }
        if (ClassUtil.isProxy(clazz)) {
            return ClassUtil.getJdkProxySuperClass(clazz);
        }
        String name = clazz.getName();
        if (name.contains(ENHANCER_BY) || name.contains(JAVASSIST_BY)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<?> getWrapType(Class<?> clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz.isArray() || clazz == int[].class || clazz == long[].class || clazz == short[].class || clazz == float[].class || clazz == double[].class;
    }

    public static boolean canInstance(int mod) {
        return !Modifier.isAbstract(mod) || !Modifier.isInterface(mod);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<?>[] declaredConstructors;
            Constructor<?> defaultConstructor = null;
            Constructor<?> otherConstructor = null;
            for (Constructor<?> constructor : declaredConstructors = clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() == 0 && Modifier.isPublic(constructor.getModifiers())) {
                    defaultConstructor = constructor;
                    continue;
                }
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                otherConstructor = constructor;
            }
            if (defaultConstructor != null) {
                return defaultConstructor.newInstance(new Object[0]);
            }
            if (otherConstructor != null) {
                Class<?>[] parameterTypes = otherConstructor.getParameterTypes();
                Object[] parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = parameterTypes[i].isPrimitive() ? ConvertUtil.getPrimitiveDefaultValue(parameterTypes[i]) : null;
                }
                return (T)otherConstructor.newInstance(parameters);
            }
            Method factoryMethod = ClassUtil.getFirstMethod(clazz, m -> m.getParameterCount() == 0 && clazz == m.getReturnType() && Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()));
            if (factoryMethod != null) {
                return (T)factoryMethod.invoke(null, new Object[0]);
            }
            throw new IllegalArgumentException("the class \"" + clazz.getName() + "\" has no constructor.");
        }
        catch (Exception e) {
            throw new RuntimeException("Can not newInstance class: " + clazz.getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... paras) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                if (!ClassUtil.isMatchedParas(constructor, paras)) continue;
                Object ret = constructor.newInstance(paras);
                return (T)ret;
            }
            throw new IllegalArgumentException("Can not find constructor by paras: \"" + Arrays.toString(paras) + "\" in class[" + clazz.getName() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isMatchedParas(Constructor<?> constructor, Object[] paras) {
        if (constructor.getParameterCount() == 0) {
            return paras == null || paras.length == 0;
        }
        if (constructor.getParameterCount() > 0 && (paras == null || paras.length != constructor.getParameterCount())) {
            return false;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Object paraObject = paras[i];
            if (paraObject == null || parameterType.isAssignableFrom(paraObject.getClass())) continue;
            return false;
        }
        return true;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(clazz, fields, null, false);
        return fields;
    }

    public static List<Field> getAllFields(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(clazz, fields, predicate, false);
        return fields;
    }

    public static Field getFirstField(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(clazz, fields, predicate, true);
        return fields.isEmpty() ? null : (Field)fields.get(0);
    }

    private static void doGetFields(Class<?> clazz, List<Field> fields, Predicate<Field> predicate, boolean firstOnly) {
        Field[] declaredFields;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            if (predicate != null && !predicate.test(declaredField)) continue;
            fields.add(declaredField);
            if (firstOnly) break;
        }
        if (firstOnly && !fields.isEmpty()) {
            return;
        }
        ClassUtil.doGetFields(clazz.getSuperclass(), fields, predicate, firstOnly);
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(clazz, methods, null, false);
        return methods;
    }

    public static List<Method> getAllMethods(Class<?> clazz, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(clazz, methods, predicate, false);
        return methods;
    }

    public static Method getAnyMethod(Class<?> clazz, String ... methodNames) {
        return ClassUtil.getFirstMethod(clazz, method -> ArrayUtil.contains(methodNames, method.getName()));
    }

    public static Method getFirstMethod(Class<?> clazz, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(clazz, methods, predicate, true);
        return methods.isEmpty() ? null : (Method)methods.get(0);
    }

    private static void doGetMethods(Class<?> clazz, List<Method> methods, Predicate<Method> predicate, boolean firstOnly) {
        Class<?>[] interfaces;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        Method[] declaredMethods = clazz.getDeclaredMethods();
        if (clazz.isInterface()) {
            for (Method method : declaredMethods) {
                if (!method.isDefault() || predicate != null && !predicate.test(method)) continue;
                methods.add(method);
                if (!firstOnly) {
                    continue;
                }
                break;
            }
        } else {
            for (Method method : declaredMethods) {
                if (predicate != null && !predicate.test(method)) continue;
                methods.add(method);
                if (!firstOnly) {
                    continue;
                }
                break;
            }
        }
        if (firstOnly && !methods.isEmpty()) {
            return;
        }
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            ClassUtil.doGetMethods(anInterface, methods, predicate, firstOnly);
        }
        ClassUtil.doGetMethods(clazz.getSuperclass(), methods, predicate, firstOnly);
    }

    private static <T> Class<T> getJdkProxySuperClass(Class<T> clazz) {
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz.getInterfaces());
        return proxyClass.getInterfaces()[0];
    }

    public static boolean isGetterMethod(Method method, String property) {
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return StringUtil.firstCharToUpperCase(property).equals(methodName.substring(3));
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return StringUtil.firstCharToUpperCase(property).equals(methodName.substring(2));
        }
        return false;
    }

    public static boolean isObjectMethod(String methodName) {
        return ArrayUtil.contains(OBJECT_METHODS, methodName);
    }
}

