/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LambdaUtil {
    private static final Map<Class<?>, SerializedLambda> lambdaMap = new ConcurrentHashMap();
    private static final Map<String, Class<?>> classMap = new ConcurrentHashMap();

    private LambdaUtil() {
    }

    public static <T> String getFieldName(LambdaGetter<T> getter) {
        SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
        String methodName = lambda.getImplMethodName();
        return StringUtil.methodToProperty(methodName);
    }

    public static <T> Class<?> getImplClass(LambdaGetter<T> getter) {
        SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
        return LambdaUtil.getImplClass(lambda, getter.getClass().getClassLoader());
    }

    public static <T> String getAliasName(LambdaGetter<T> getter, boolean withPrefix) {
        QueryColumn queryColumn = LambdaUtil.getQueryColumn(getter);
        if (queryColumn != null) {
            String alias = StringUtil.isNotBlank(queryColumn.getAlias()) ? queryColumn.getAlias() : queryColumn.getName();
            return withPrefix ? queryColumn.getTable().getName() + "$" + alias : alias;
        }
        return LambdaUtil.getFieldName(getter);
    }

    public static <T> QueryColumn getQueryColumn(LambdaGetter<T> getter) {
        ClassLoader classLoader = getter.getClass().getClassLoader();
        SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
        String methodName = lambda.getImplMethodName();
        Class<?> entityClass = LambdaUtil.getImplClass(lambda, classLoader);
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        return tableInfo.getQueryColumnByProperty(StringUtil.methodToProperty(methodName));
    }

    private static SerializedLambda getSerializedLambda(Serializable getter) {
        return MapUtil.computeIfAbsent(lambdaMap, getter.getClass(), aClass -> {
            try {
                Method method = getter.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(Boolean.TRUE);
                return (SerializedLambda)method.invoke((Object)getter, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Class<?> getImplClass(SerializedLambda lambda, ClassLoader classLoader) {
        String implClass = LambdaUtil.getImplClassName(lambda);
        return MapUtil.computeIfAbsent(classMap, implClass, s -> {
            try {
                return Class.forName(s.replace("/", "."), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw FlexExceptions.wrap(e);
            }
        });
    }

    private static String getImplClassName(SerializedLambda lambda) {
        String type = lambda.getInstantiatedMethodType();
        return type.substring(2, type.indexOf(";"));
    }
}

