/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AbstractMessageCollector;
import com.mybatisflex.core.audit.ConsoleMessageReporter;
import com.mybatisflex.core.audit.MessageReporter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ScheduledMessageCollector
extends AbstractMessageCollector {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "ScheduledMessageCollector");
        thread.setDaemon(true);
        return thread;
    });

    public ScheduledMessageCollector() {
        this(10L, new ConsoleMessageReporter());
    }

    public ScheduledMessageCollector(long period, MessageReporter messageSender) {
        super(messageSender);
        this.scheduler.scheduleAtFixedRate(this::doSendMessages, period, period, TimeUnit.SECONDS);
    }

    @Override
    public void release() {
        this.doSendMessages();
        this.scheduler.shutdown();
    }
}

