/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.WithItem;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class With
implements CloneSupport<With> {
    private boolean recursive;
    private List<WithItem> withItems;

    public With() {
    }

    public With(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public List<WithItem> getWithItems() {
        return this.withItems;
    }

    public void setWithItems(List<WithItem> withItems) {
        this.withItems = withItems;
    }

    public void addWithItem(WithItem withItem) {
        if (this.withItems == null) {
            this.withItems = new ArrayList<WithItem>();
        }
        this.withItems.add(withItem);
    }

    public String toSql(IDialect dialect) {
        StringBuilder sql = new StringBuilder("WITH ");
        if (this.recursive) {
            sql.append("RECURSIVE ");
        }
        for (int i = 0; i < this.withItems.size(); ++i) {
            sql.append(this.withItems.get(i).toSql(dialect));
            if (i == this.withItems.size() - 1) continue;
            sql.append(", ");
        }
        return sql.append(" ").toString();
    }

    public Object[] getParamValues() {
        Object[] paramValues = FlexConsts.EMPTY_ARRAY;
        for (WithItem withItem : this.withItems) {
            paramValues = ArrayUtil.concat(paramValues, withItem.getParamValues());
        }
        return paramValues;
    }

    @Override
    public With clone() {
        try {
            With clone = (With)super.clone();
            clone.withItems = CollectionUtil.cloneArrayList(this.withItems);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

