/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.util.StringUtil;
import java.util.Collections;
import java.util.Set;

public class KeywordWrap {
    public static final KeywordWrap NONE = new KeywordWrap("", ""){

        @Override
        public String wrap(String keyword) {
            return keyword;
        }
    };
    public static final KeywordWrap NONE_CASE_SENSITIVE = new KeywordWrap(true, "", ""){

        @Override
        public String wrap(String keyword) {
            return keyword;
        }
    };
    public static final KeywordWrap BACK_QUOTE = new KeywordWrap("`", "`");
    public static final KeywordWrap DOUBLE_QUOTATION = new KeywordWrap("\"", "\"");
    public static final KeywordWrap SQUARE_BRACKETS = new KeywordWrap("[", "]");
    private boolean caseSensitive = false;
    private boolean keywordsToUpperCase = false;
    private final Set<String> keywords;
    private final String prefix;
    private final String suffix;

    public KeywordWrap(String prefix, String suffix) {
        this(false, Collections.emptySet(), prefix, suffix);
    }

    public KeywordWrap(boolean caseSensitive, String prefix, String suffix) {
        this(caseSensitive, Collections.emptySet(), prefix, suffix);
    }

    public KeywordWrap(Set<String> keywords, String prefix, String suffix) {
        this(false, keywords, prefix, suffix);
    }

    public KeywordWrap(boolean caseSensitive, Set<String> keywords, String prefix, String suffix) {
        this.caseSensitive = caseSensitive;
        this.keywords = keywords;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public KeywordWrap(boolean caseSensitive, boolean keywordsToUpperCase, Set<String> keywords, String prefix, String suffix) {
        this.caseSensitive = caseSensitive;
        this.keywordsToUpperCase = keywordsToUpperCase;
        this.keywords = keywords;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String wrap(String keyword) {
        if (StringUtil.isBlank(keyword) || "*".equals(keyword.trim())) {
            return keyword;
        }
        if (this.caseSensitive || this.keywords.isEmpty()) {
            return this.prefix + keyword + this.suffix;
        }
        keyword = this.keywordsToUpperCase ? keyword.toUpperCase() : keyword;
        return this.keywords.contains(keyword) ? this.prefix + keyword + this.suffix : keyword;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isKeywordsToUpperCase() {
        return this.keywordsToUpperCase;
    }

    public void setKeywordsToUpperCase(boolean keywordsToUpperCase) {
        this.keywordsToUpperCase = keywordsToUpperCase;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

