/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.keygen.KeyGeneratorFactory;
import com.mybatisflex.core.keygen.MybatisKeyGeneratorUtil;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.StringUtil;
import java.sql.Statement;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

public class CustomKeyGenerator
implements KeyGenerator {
    protected Configuration configuration;
    protected IKeyGenerator keyGenerator;
    protected TableInfo tableInfo;
    protected IdInfo idInfo;

    public CustomKeyGenerator(Configuration configuration, TableInfo tableInfo, IdInfo idInfo) {
        this.configuration = configuration;
        FlexGlobalConfig.KeyConfig globalKeyConfig = FlexGlobalConfig.getConfig(configuration).getKeyConfig();
        String keyValue = MybatisKeyGeneratorUtil.getKeyValue(idInfo, globalKeyConfig);
        this.keyGenerator = KeyGeneratorFactory.getKeyGenerator(keyValue);
        this.tableInfo = tableInfo;
        this.idInfo = idInfo;
        this.ensuresKeyGeneratorNotNull();
    }

    private void ensuresKeyGeneratorNotNull() {
        if (this.keyGenerator == null) {
            throw FlexExceptions.wrap("The name of \"%s\" key generator not exist.\nplease check annotation @Id(value=\"%s\") at field: %s#%s", this.idInfo.getValue(), this.idInfo.getValue(), this.tableInfo.getEntityClass().getName(), this.idInfo.getProperty());
        }
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        Object entity = ((Map)parameter).get("$$entity");
        try {
            Object existId = this.tableInfo.getValue(entity, this.idInfo.getProperty());
            if (existId == null || existId instanceof String && StringUtil.isBlank((String)existId)) {
                Configuration configuration = ms.getConfiguration();
                MetaObject metaParam = configuration.newMetaObject(parameter);
                Object generateId = this.keyGenerator.generate(entity, this.idInfo.getColumn());
                MetaObject metaObjectForProperty = metaParam.metaObjectForProperty("$$entity");
                Class setterType = this.tableInfo.getReflector().getSetterType(this.idInfo.getProperty());
                Object id = ConvertUtil.convert(generateId, setterType);
                this.setValue(metaObjectForProperty, this.idInfo.getProperty(), id);
            }
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    private void setValue(MetaObject metaParam, String property, Object value) {
        if (!metaParam.hasSetter(property)) {
            throw new ExecutorException("No setter found for the keyProperty '" + property + "' in " + metaParam.getOriginalObject().getClass().getName() + ".");
        }
        metaParam.setValue(property, value);
    }
}

