/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawQueryCondition;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import java.util.ListIterator;
import java.util.function.Consumer;

public class Joiner<M extends QueryWrapper> {
    private final M queryWrapper;
    private final Join join;

    public Joiner(M queryWrapper, Join join) {
        this.queryWrapper = queryWrapper;
        this.join = join;
    }

    public Joiner<M> as(String alias) {
        this.join.queryTable = this.join.getQueryTable().as(alias);
        ListIterator<QueryTable> itr = ((QueryWrapper)this.queryWrapper).joinTables.listIterator();
        while (itr.hasNext()) {
            if (!((QueryTable)itr.next()).isSameTable(this.join.queryTable)) continue;
            itr.set(this.join.queryTable);
            break;
        }
        return this;
    }

    public M on(String on) {
        this.join.on(new RawQueryCondition(on));
        return this.queryWrapper;
    }

    public M on(QueryCondition on) {
        this.join.on(on);
        return this.queryWrapper;
    }

    public M on(Consumer<QueryWrapper> consumer) {
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        this.join.on(newWrapper.whereQueryCondition);
        return this.queryWrapper;
    }

    public <T, K> M on(LambdaGetter<T> column1, LambdaGetter<K> column2) {
        QueryCondition queryCondition = LambdaUtil.getQueryColumn(column1).eq(LambdaUtil.getQueryColumn(column2));
        this.join.on(queryCondition);
        return this.queryWrapper;
    }
}

