/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LambdaUtil {
    private static final Map<Class<?>, String> fieldNameMap = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> implClassMap = new ConcurrentHashMap();
    private static final Map<Class<?>, QueryColumn> queryColumnMap = new ConcurrentHashMap();

    private LambdaUtil() {
    }

    public static <T> String getFieldName(LambdaGetter<T> getter) {
        return MapUtil.computeIfAbsent(fieldNameMap, getter.getClass(), aClass -> {
            SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
            if (lambda.getCapturedArgCount() == 1) {
                Object capturedArg = lambda.getCapturedArg(0);
                try {
                    return (String)capturedArg.getClass().getMethod("getName", new Class[0]).invoke(capturedArg, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String methodName = lambda.getImplMethodName();
            return StringUtil.methodToProperty(methodName);
        });
    }

    public static <T> Class<?> getImplClass(LambdaGetter<T> getter) {
        return MapUtil.computeIfAbsent(implClassMap, getter.getClass(), aClass -> {
            SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
            return LambdaUtil.getImplClass(lambda, getter.getClass().getClassLoader());
        });
    }

    public static <T> String getAliasName(LambdaGetter<T> getter, boolean withPrefix) {
        QueryColumn queryColumn = LambdaUtil.getQueryColumn(getter);
        if (queryColumn != null) {
            String alias = StringUtil.isNotBlank(queryColumn.getAlias()) ? queryColumn.getAlias() : queryColumn.getName();
            return withPrefix ? queryColumn.getTable().getName() + "$" + alias : alias;
        }
        return LambdaUtil.getFieldName(getter);
    }

    public static <T> QueryColumn getQueryColumn(LambdaGetter<T> getter) {
        return MapUtil.computeIfAbsent(queryColumnMap, getter.getClass(), aClass -> {
            ClassLoader classLoader = getter.getClass().getClassLoader();
            SerializedLambda lambda = LambdaUtil.getSerializedLambda(getter);
            Class<?> entityClass = LambdaUtil.getImplClass(lambda, classLoader);
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
            String propertyName = LambdaUtil.getFieldName(getter);
            return tableInfo.getQueryColumnByProperty(propertyName);
        });
    }

    private static SerializedLambda getSerializedLambda(Serializable getter) {
        try {
            Method method = getter.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke((Object)getter, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getImplClass(SerializedLambda lambda, ClassLoader classLoader) {
        String implClass = LambdaUtil.getImplClassName(lambda);
        try {
            return Class.forName(implClass.replace("/", "."), true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw FlexExceptions.wrap(e);
        }
    }

    private static String getImplClassName(SerializedLambda lambda) {
        String type = lambda.getInstantiatedMethodType();
        return type.substring(2, type.indexOf(";"));
    }
}

