/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.ColumnAlias;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.processor.builder.ContentBuilder;
import com.mybatisflex.processor.config.ConfigurationKey;
import com.mybatisflex.processor.config.MybatisFlexConfig;
import com.mybatisflex.processor.entity.ColumnInfo;
import com.mybatisflex.processor.entity.TableInfo;
import com.mybatisflex.processor.util.FileUtil;
import com.mybatisflex.processor.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class MybatisFlexProcessor
extends AbstractProcessor {
    private static final List<String> DEFAULT_SUPPORT_COLUMN_TYPES = Arrays.asList(Integer.TYPE.getName(), Integer.class.getName(), Short.TYPE.getName(), Short.class.getName(), Long.TYPE.getName(), Long.class.getName(), Float.TYPE.getName(), Float.class.getName(), Double.TYPE.getName(), Double.class.getName(), Boolean.TYPE.getName(), Boolean.class.getName(), java.util.Date.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName(), Year.class.getName(), Month.class.getName(), YearMonth.class.getName(), JapaneseDate.class.getName(), byte[].class.getName(), Byte[].class.getName(), Byte.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), Character.TYPE.getName(), String.class.getName(), Character.class.getName());
    private Filer filer;
    private Types typeUtils;
    private Elements elementUtils;
    private MybatisFlexConfig configuration;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.configuration = new MybatisFlexConfig(this.filer);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            StringBuilder fieldBuilder;
            StringBuilder importBuilder;
            if ("false".equalsIgnoreCase(this.configuration.get(ConfigurationKey.ENABLE))) {
                return true;
            }
            System.out.println("mybatis flex processor run start...");
            boolean allInTablesEnable = "true".equalsIgnoreCase(this.configuration.get(ConfigurationKey.ALL_IN_TABLES_ENABLE));
            if (allInTablesEnable) {
                importBuilder = new StringBuilder();
                fieldBuilder = new StringBuilder();
            } else {
                fieldBuilder = null;
                importBuilder = null;
            }
            String genPath = this.configuration.get(ConfigurationKey.GEN_PATH);
            String allInTablesPackage = this.configuration.get(ConfigurationKey.ALL_IN_TABLES_PACKAGE);
            String allInTablesClassName = this.configuration.get(ConfigurationKey.ALL_IN_TABLES_CLASS_NAME);
            String mapperGenerateEnable = this.configuration.get(ConfigurationKey.MAPPER_GENERATE_ENABLE);
            String mapperAnnotation = this.configuration.get(ConfigurationKey.MAPPER_ANNOTATION);
            String mapperPackage = this.configuration.get(ConfigurationKey.MAPPER_PACKAGE);
            String mapperBaseClass = this.configuration.get(ConfigurationKey.MAPPER_BASE_CLASS);
            String tableDefClassSuffix = this.configuration.get(ConfigurationKey.TABLE_DEF_CLASS_SUFFIX);
            String tableDefInstanceSuffix = this.configuration.get(ConfigurationKey.TABLE_DEF_INSTANCE_SUFFIX);
            String tableDefPropertiesNameStyle = this.configuration.get(ConfigurationKey.TABLE_DEF_PROPERTIES_NAME_STYLE);
            String[] tableDefIgnoreEntitySuffixes = this.configuration.get(ConfigurationKey.TABLE_DEF_IGNORE_ENTITY_SUFFIXES).split(",");
            String entityClassReference = null;
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(Table.class);
            for (Element element : elementsAnnotatedWith) {
                Table table = element.getAnnotation(Table.class);
                assert (table != null);
                TreeSet<ColumnInfo> columnInfos = new TreeSet<ColumnInfo>();
                ArrayList<String> defaultColumns = new ArrayList<String>();
                TypeElement classElement = (TypeElement)element;
                do {
                    this.fillColumnInfoList(columnInfos, defaultColumns, (TypeElement)element, classElement, table.camelToUnderline());
                } while ((classElement = (TypeElement)this.typeUtils.asElement(classElement.getSuperclass())) != null);
                String entityClass = element.toString();
                String entityClassName = StrUtil.getClassName(entityClass);
                for (String entityIgnoreSuffix : tableDefIgnoreEntitySuffixes) {
                    if ((entityIgnoreSuffix = entityIgnoreSuffix.trim()).isEmpty() || !entityClassName.endsWith(entityIgnoreSuffix)) continue;
                    entityClassName = entityClassName.substring(0, entityClassName.length() - entityIgnoreSuffix.length());
                    break;
                }
                TableInfo tableInfo = new TableInfo();
                tableInfo.setEntityName(entityClass);
                tableInfo.setEntitySimpleName(entityClassName);
                tableInfo.setSchema(table.schema());
                tableInfo.setTableName(table.value());
                tableInfo.setEntityComment(this.elementUtils.getDocComment(element));
                String tableDefPackage = StrUtil.buildTableDefPackage(entityClass);
                String tableDefClassName = entityClassName.concat(tableDefClassSuffix);
                String tableDefContent = ContentBuilder.buildTableDef(tableInfo, allInTablesEnable, tableDefPackage, tableDefClassName, tableDefPropertiesNameStyle, tableDefInstanceSuffix, columnInfos, defaultColumns);
                this.processGenClass(genPath, tableDefPackage, tableDefClassName, tableDefContent, element);
                if (allInTablesEnable) {
                    entityClassReference = entityClass;
                    ContentBuilder.buildTablesField(importBuilder, fieldBuilder, tableInfo, tableDefClassSuffix, tableDefPropertiesNameStyle, tableDefInstanceSuffix);
                }
                if (!"true".equalsIgnoreCase(mapperGenerateEnable) || !table.mapperGenerateEnable()) continue;
                String realMapperPackage = StrUtil.isBlank(mapperPackage) ? StrUtil.buildMapperPackage(entityClass) : mapperPackage;
                String mapperClassName = entityClassName.concat("Mapper");
                boolean mapperAnnotationEnable = "true".equalsIgnoreCase(mapperAnnotation);
                String mapperClassContent = ContentBuilder.buildMapper(tableInfo, realMapperPackage, mapperClassName, mapperBaseClass, mapperAnnotationEnable);
                this.processGenClass(genPath, realMapperPackage, mapperClassName, mapperClassContent, element);
            }
            if (allInTablesEnable && entityClassReference != null) {
                String realTablesPackage = StrUtil.isBlank(allInTablesPackage) ? StrUtil.buildTableDefPackage(entityClassReference) : allInTablesPackage;
                String string = StrUtil.isBlank(allInTablesClassName) ? "Tables" : allInTablesClassName;
                String tablesContent = ContentBuilder.buildTables(importBuilder, fieldBuilder, realTablesPackage, allInTablesClassName);
                this.processGenClass(genPath, realTablesPackage, string, tablesContent, elementsAnnotatedWith.toArray(new Element[0]));
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(Table.class.getCanonicalName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void fillColumnInfoList(Set<ColumnInfo> columnInfos, List<String> defaultColumns, TypeElement baseElement, TypeElement classElement, boolean camelToUnderline) {
        for (Element element : classElement.getEnclosedElements()) {
            ColumnAlias columnAlias;
            Column column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC) || (column = element.getAnnotation(Column.class)) != null && column.ignore()) continue;
            String[] typeHandlerClass = new String[]{""};
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                annotationMirror.getElementValues().forEach((executableElement, annotationValue) -> {
                    if ("typeHandler".contentEquals(executableElement.getSimpleName())) {
                        typeHandlerClass[0] = annotationValue.toString();
                    }
                });
            }
            TypeMirror typeMirror = element.asType();
            Element element2 = this.typeUtils.asElement(typeMirror);
            if (element2 != null) {
                typeMirror = element2.asType();
            }
            String typeString = typeMirror.toString().trim();
            TypeElement typeElement = null;
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            }
            if ((column == null || "org.apache.ibatis.type.UnknownTypeHandler".equals(typeHandlerClass[0])) && !DEFAULT_SUPPORT_COLUMN_TYPES.contains(typeString) && typeElement != null && ElementKind.ENUM != typeElement.getKind()) continue;
            String property = element.toString();
            String columnName = column != null && !StrUtil.isBlank(column.value()) ? column.value() : (camelToUnderline ? StrUtil.camelToUnderline(property) : property);
            String[] alias = this.getColumnAliasByGetterMethod(baseElement, property);
            if ((alias == null || alias.length == 0) && (columnAlias = element.getAnnotation(ColumnAlias.class)) != null) {
                alias = columnAlias.value();
            }
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setProperty(property);
            columnInfo.setColumn(columnName);
            columnInfo.setAlias(alias);
            columnInfo.setComment(this.elementUtils.getDocComment(element));
            columnInfos.add(columnInfo);
            if (column != null && (column.isLarge() || column.isLogicDelete())) continue;
            defaultColumns.add(columnName);
        }
    }

    private String[] getColumnAliasByGetterMethod(TypeElement baseElement, String property) {
        if (baseElement == null) {
            return null;
        }
        for (Element element : baseElement.getEnclosedElements()) {
            String methodName;
            if (ElementKind.METHOD != element.getKind() || !StrUtil.isGetterMethod(methodName = element.toString(), property)) continue;
            ColumnAlias columnAlias = element.getAnnotation(ColumnAlias.class);
            if (columnAlias != null) {
                return columnAlias.value();
            }
            return null;
        }
        return this.getColumnAliasByGetterMethod((TypeElement)this.typeUtils.asElement(baseElement.getSuperclass()), property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processGenClass(String genBasePath, String genPackageName, String className, String genContent, Element ... elements) {
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, elements);
            if (genBasePath == null || genBasePath.trim().length() == 0) {
                writer = new OutputStreamWriter(sourceFile.openOutputStream(), this.configuration.get(ConfigurationKey.CHARSET));
                writer.write(genContent);
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (FileUtil.isAbsolutePath(genBasePath)) {
                realPath = genBasePath;
            } else {
                String projectRootPath = FileUtil.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, genBasePath).getAbsolutePath();
            }
            boolean fromTestSource = FileUtil.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.err.println(">>>>> ERROR: can not mkdirs by mybatis-flex processor for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(genJavaFile, this.configuration.get(ConfigurationKey.CHARSET));
            writer.write(genContent);
            writer.flush();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

