/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FileUtil {
    private static Set<String> flagFileNames = new HashSet<String>(Arrays.asList("pom.xml", "build.gradle", "build.gradle.kts"));

    private FileUtil() {
    }

    public static boolean existsBuildFile(File dir) {
        for (String fileName : flagFileNames) {
            if (!new File(dir, fileName).exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.contains(":"));
    }

    public static String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return FileUtil.getProjectRootPath(file, count);
    }

    public static String getProjectRootPath(File file, int depth) {
        if (depth <= 0 || file == null) {
            return null;
        }
        if (file.isFile()) {
            return FileUtil.getProjectRootPath(file.getParentFile(), depth - 1);
        }
        if (FileUtil.existsBuildFile(file) && !FileUtil.existsBuildFile(file.getParentFile())) {
            return file.getAbsolutePath();
        }
        return FileUtil.getProjectRootPath(file.getParentFile(), depth - 1);
    }
}

