/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrUtil {
    private static final Pattern PACKAGE_REGEX = Pattern.compile("(?<expression>\\$\\{entityPackage[.parent]*\\})(?<subPackage>.*)");

    private StrUtil() {
    }

    public static String getClassName(String str) {
        return str.substring(str.lastIndexOf(".") + 1);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String camelToUnderline(String str) {
        if (StrUtil.isBlank(str)) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char prev;
            char c = str.charAt(i);
            if (Character.isUpperCase(c) && i > 0 && !Character.isUpperCase(prev = str.charAt(i - 1)) && prev != '_') {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String buildFieldName(String name, String tableDefPropertiesNameStyle) {
        if ("upperCase".equalsIgnoreCase(tableDefPropertiesNameStyle)) {
            return StrUtil.camelToUnderline(name).toUpperCase();
        }
        if ("lowerCase".equalsIgnoreCase(tableDefPropertiesNameStyle)) {
            return StrUtil.camelToUnderline(name).toLowerCase();
        }
        if ("upperCamelCase".equalsIgnoreCase(tableDefPropertiesNameStyle)) {
            return StrUtil.firstCharToUpperCase(name);
        }
        return StrUtil.firstCharToLowerCase(name);
    }

    public static String buildTableDefPackage(String entityClass) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClass.contains(".")) {
            guessPackage.append("table");
        } else {
            guessPackage.append(entityClass, 0, entityClass.lastIndexOf(".")).append(".table");
        }
        return guessPackage.toString();
    }

    public static String buildMapperPackage(String entityClass) {
        if (!entityClass.contains(".")) {
            return "mapper";
        }
        String entityPackage = entityClass.substring(0, entityClass.lastIndexOf("."));
        if (entityPackage.contains(".")) {
            return entityPackage.substring(0, entityPackage.lastIndexOf(".")) + ".mapper";
        }
        return "mapper";
    }

    public static String processPackageExpression(String entityClass, String packageStr) {
        String entityPackage = entityClass.substring(0, entityClass.lastIndexOf("."));
        Matcher matcher = PACKAGE_REGEX.matcher(packageStr);
        if (!matcher.find()) {
            return entityPackage;
        }
        String expression = matcher.group("expression");
        expression = expression.substring(2, expression.length() - 1);
        String subPackage = matcher.group("subPackage");
        List<String> entityPackageSplit = Arrays.asList(entityPackage.split("\\."));
        while (expression.contains(".parent")) {
            if (entityPackageSplit.size() == 0) {
                throw new RuntimeException("Expression [.parent] has exceeded the maximum limit.");
            }
            int index = expression.lastIndexOf(".parent");
            if (index == -1) continue;
            expression = expression.substring(0, index);
            entityPackageSplit = entityPackageSplit.subList(0, entityPackageSplit.size() - 1);
        }
        expression = expression.replace("entityPackage", String.join((CharSequence)".", entityPackageSplit));
        return expression + subPackage;
    }

    public static boolean isGetterMethod(String methodName, String property) {
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return StrUtil.firstCharToUpperCase(property).concat("()").equals(methodName.substring(3));
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return StrUtil.firstCharToUpperCase(property).concat("()").equals(methodName.substring(2));
        }
        return false;
    }
}

