/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.solon;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.MybatisFlexBootstrap;
import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.mybatis.FlexSqlSessionFactoryBuilder;
import com.mybatisflex.core.row.RowMapperInvoker;
import com.mybatisflex.solon.ConfigurationCustomizer;
import com.mybatisflex.solon.MyBatisFlexCustomizer;
import com.mybatisflex.solon.MybatisFlexProperties;
import com.mybatisflex.solon.transaction.MybatisSessionTemplate;
import com.mybatisflex.solon.transaction.SolonManagedTransactionFactory;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ResourceUtil;

@Configuration
public class MybatisFlexAutoConfiguration {
    @Inject
    private AppContext appContext;

    private DataSource getDataSource() {
        return MybatisFlexBootstrap.getInstance().getDataSource();
    }

    @Bean
    public FlexConfiguration configuration(MybatisFlexProperties flexProperties, @Inject(required=false) ConfigurationCustomizer configurationCustomizer) {
        SolonManagedTransactionFactory tf = new SolonManagedTransactionFactory();
        Environment environment = new Environment("MyBatis-Flex", (TransactionFactory)tf, this.getDataSource());
        FlexConfiguration configuration = new FlexConfiguration(environment);
        if (Utils.isNotEmpty((Map)flexProperties.getConfigurationProperties())) {
            Utils.injectProperties((Object)configuration, (Properties)flexProperties.getConfigurationProperties());
        }
        if (flexProperties.getConfiguration() != null) {
            flexProperties.getConfiguration().applyTo((org.apache.ibatis.session.Configuration)configuration);
        }
        if (configurationCustomizer != null) {
            configurationCustomizer.customize(configuration);
        }
        EventBus.publish((Object)configuration);
        return configuration;
    }

    @Bean
    @Condition(onMissingBean=SqlSessionFactoryBuilder.class)
    public SqlSessionFactoryBuilder sqlSessionFactoryBuilder() {
        return new FlexSqlSessionFactoryBuilder();
    }

    @Bean
    public FlexGlobalConfig globalConfig(MybatisFlexProperties flexProperties, FlexConfiguration flexConfiguration, @Inject(required=false) MyBatisFlexCustomizer flexCustomizer) {
        FlexGlobalConfig globalConfig = FlexGlobalConfig.getDefaultConfig();
        if (flexProperties.getGlobalConfig() != null) {
            flexProperties.getGlobalConfig().applyTo(globalConfig);
        }
        if (globalConfig.getKeyConfig() == null) {
            globalConfig.setKeyConfig(new FlexGlobalConfig.KeyConfig());
        }
        globalConfig.setConfiguration((org.apache.ibatis.session.Configuration)flexConfiguration);
        if (flexCustomizer != null) {
            flexCustomizer.customize(globalConfig);
        }
        EventBus.publish((Object)globalConfig);
        FlexGlobalConfig.setConfig((String)flexConfiguration.getEnvironment().getId(), (FlexGlobalConfig)globalConfig, (boolean)true);
        return globalConfig;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(MybatisFlexProperties flexProperties, FlexConfiguration flexConfiguration, FlexGlobalConfig globalConfig, SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.appContext.subBeansOfType(Interceptor.class, bean -> flexConfiguration.addInterceptor(bean));
        if (this.isNotEmpty(flexProperties.getTypeAliasesPackage())) {
            Class<?> typeAliasesSuperType = flexProperties.getTypeAliasesSuperType();
            String[] stringArray = flexProperties.getTypeAliasesPackage();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String val = stringArray[i];
                for (Class clz : ResourceUtil.scanClasses((ClassLoader)this.appContext.getClassLoader(), (String)val)) {
                    if (!this.isTypeAliases(clz, typeAliasesSuperType)) continue;
                    flexConfiguration.getTypeAliasRegistry().registerAlias(clz);
                }
            }
        }
        if (this.isNotEmpty(flexProperties.getTypeHandlersPackage())) {
            for (String val : flexProperties.getTypeHandlersPackage()) {
                for (Class clz : ResourceUtil.scanClasses((ClassLoader)this.appContext.getClassLoader(), (String)val)) {
                    if (!TypeHandler.class.isAssignableFrom(clz)) continue;
                    flexConfiguration.getTypeHandlerRegistry().register(clz);
                }
            }
        }
        if (this.isNotEmpty(flexProperties.getMapperLocations())) {
            for (String val : flexProperties.getMapperLocations()) {
                if (ResourceUtil.hasClasspath((String)val)) {
                    for (String uri : ResourceUtil.scanResources((String)val)) {
                        this.addMapperByXml(flexConfiguration, uri);
                    }
                    continue;
                }
                for (Class clz : ResourceUtil.scanClasses((ClassLoader)this.appContext.getClassLoader(), (String)val)) {
                    if (!clz.isInterface()) continue;
                    flexConfiguration.addMapper(clz);
                }
            }
            if (flexConfiguration.getMapperRegistry().getMappers().size() == 0) {
                throw new IllegalStateException("Missing mapper registration, please check the 'mapperLocations' configuration!");
            }
        }
        return sqlSessionFactoryBuilder.build((org.apache.ibatis.session.Configuration)flexConfiguration);
    }

    @Bean
    public void mapperPublish(FlexConfiguration flexConfiguration, FlexGlobalConfig globalConfig, SqlSessionFactory sqlSessionFactory) {
        MybatisSessionTemplate sqlSessionTemplate = new MybatisSessionTemplate(sqlSessionFactory);
        for (Class mapperClz : flexConfiguration.getMapperRegistry().getMappers()) {
            Object mapperProxy = sqlSessionTemplate.getMapper(mapperClz);
            this.appContext.wrapAndPut(mapperClz, mapperProxy);
        }
    }

    @Bean
    public RowMapperInvoker rowMapperInvoker(SqlSessionFactory sqlSessionFactory) {
        return new RowMapperInvoker(sqlSessionFactory);
    }

    private void addMapperByXml(FlexConfiguration flexConfiguration, String uri) {
        try {
            ErrorContext.instance().resource(uri);
            InputStream stream = Resources.getResourceAsStream((String)uri);
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, (org.apache.ibatis.session.Configuration)flexConfiguration, uri, flexConfiguration.getSqlFragments());
            mapperParser.parse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNotEmpty(String[] ary) {
        return ary != null && ary.length > 0;
    }

    private boolean isTypeAliases(Class<?> clz, Class<?> typeAliasesSuperType) {
        if (clz.isInterface()) {
            return false;
        }
        if (typeAliasesSuperType != null) {
            return typeAliasesSuperType.isAssignableFrom(clz);
        }
        return true;
    }
}

