/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.solon.integration;

import com.mybatisflex.annotation.UseDataSource;
import com.mybatisflex.core.MybatisFlexBootstrap;
import com.mybatisflex.core.datasource.DataSourceBuilder;
import com.mybatisflex.core.datasource.DataSourceDecipher;
import com.mybatisflex.core.datasource.DataSourceManager;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.logicdelete.LogicDeleteManager;
import com.mybatisflex.core.logicdelete.LogicDeleteProcessor;
import com.mybatisflex.core.table.DynamicSchemaProcessor;
import com.mybatisflex.core.table.DynamicTableProcessor;
import com.mybatisflex.core.table.TableManager;
import com.mybatisflex.core.tenant.TenantFactory;
import com.mybatisflex.core.tenant.TenantManager;
import com.mybatisflex.solon.MybatisFlexAutoConfiguration;
import com.mybatisflex.solon.MybatisFlexProperties;
import com.mybatisflex.solon.annotation.UseDataSourceInterceptor;
import com.mybatisflex.solon.aot.MybatisRuntimeNativeRegistrar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.aot.RuntimeNativeRegistrar;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;

public class MybatisFlexPlugin
implements Plugin {
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void start(AppContext context) throws Throwable {
        MybatisFlexProperties flexProperties = (MybatisFlexProperties)context.beanMake(MybatisFlexProperties.class).get();
        if (Utils.isNotEmpty(flexProperties.getDatasource())) {
            for (Map.Entry<String, Map<String, String>> entry : flexProperties.getDatasource().entrySet()) {
                String dsName = entry.getKey();
                DataSource ds = new DataSourceBuilder(entry.getValue()).build();
                BeanWrap bw2 = context.wrap(dsName, (Object)ds, dsName.equals(flexProperties.getDefaultDatasourceKey()));
                context.putWrap(dsName, bw2);
                if (bw2.typed()) {
                    context.putWrap(DataSource.class, bw2);
                }
                context.wrapPublish(bw2);
            }
        }
        context.beanInterceptorAdd(UseDataSource.class, (Interceptor)new UseDataSourceInterceptor());
        context.getBeanAsync(DataSourceDecipher.class, bean -> DataSourceManager.setDecipher((DataSourceDecipher)bean));
        context.getBeanAsync(DynamicTableProcessor.class, bean -> TableManager.setDynamicTableProcessor((DynamicTableProcessor)bean));
        context.getBeanAsync(DynamicSchemaProcessor.class, bean -> TableManager.setDynamicSchemaProcessor((DynamicSchemaProcessor)bean));
        context.getBeanAsync(TenantFactory.class, bean -> TenantManager.setTenantFactory((TenantFactory)bean));
        context.getBeanAsync(LogicDeleteProcessor.class, bean -> LogicDeleteManager.setProcessor((LogicDeleteProcessor)bean));
        context.subWrapsOfType(DataSource.class, bw -> this.loadDs(context, (BeanWrap)bw));
        if (NativeDetector.isAotRuntime() && ClassUtil.hasClass(() -> RuntimeNativeRegistrar.class)) {
            context.wrapAndPut(MybatisRuntimeNativeRegistrar.class);
        }
    }

    private void loadDs(AppContext context, BeanWrap bw) {
        MybatisFlexBootstrap.getInstance().addDataSource(bw.name(), (DataSource)bw.raw());
        if (bw.typed()) {
            FlexDataSource flexDataSource = (FlexDataSource)MybatisFlexBootstrap.getInstance().getDataSource();
            flexDataSource.setDefaultDataSource(bw.name());
        }
        if (this.initialized.compareAndSet(false, true)) {
            context.beanMake(MybatisFlexAutoConfiguration.class);
        }
    }
}

