/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.solon.transaction;

import com.mybatisflex.core.datasource.FlexDataSourceRouting;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.apache.ibatis.transaction.Transaction;
import org.noear.solon.data.tran.TranUtils;

public class SolonManagedTransaction
implements Transaction {
    private DataSource dataSource;
    private Connection connection;

    public SolonManagedTransaction(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            DataSource selected = FlexDataSourceRouting.determineCurrentTarget(this.dataSource);
            this.connection = TranUtils.getConnectionProxy((DataSource)selected);
        }
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Integer getTimeout() throws SQLException {
        if (this.connection != null) {
            try {
                return this.connection.getNetworkTimeout();
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
        }
        return null;
    }
}

