/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import com.mybatisflex.core.datasource.DataSourceBuilder;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.spring.boot.ConditionalOnMybatisFlexDatasource;
import com.mybatisflex.spring.boot.MybatisFlexProperties;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnMybatisFlexDatasource
@EnableConfigurationProperties(value={MybatisFlexProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class MultiDataSourceAutoConfiguration {
    private Map<String, Map<String, String>> dataSourceProperties;

    public MultiDataSourceAutoConfiguration(MybatisFlexProperties properties) {
        this.dataSourceProperties = properties.getDatasource();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource() {
        FlexDataSource flexDataSource = null;
        if (this.dataSourceProperties != null && !this.dataSourceProperties.isEmpty()) {
            for (String key : this.dataSourceProperties.keySet()) {
                DataSource dataSource = new DataSourceBuilder(this.dataSourceProperties.get(key)).build();
                if (flexDataSource == null) {
                    flexDataSource = new FlexDataSource(key, dataSource);
                    continue;
                }
                flexDataSource.addDataSource(key, dataSource);
            }
        }
        return flexDataSource;
    }
}

