/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Conditional(value={OnMybatisFlexDataSourceCondition.class})
public @interface ConditionalOnMybatisFlexDatasource {

    public static class OnMybatisFlexDataSourceCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment env = context.getEnvironment();
            if (env instanceof AbstractEnvironment) {
                MutablePropertySources propertySources = ((AbstractEnvironment)env).getPropertySources();
                Iterator it = propertySources.stream().iterator();
                while (it.hasNext()) {
                    PropertySource ps = (PropertySource)it.next();
                    if (!(ps instanceof MapPropertySource)) continue;
                    for (String propertyName : ((Map)((MapPropertySource)ps).getSource()).keySet()) {
                        if (!propertyName.startsWith("mybatis-flex.datasource.")) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

