/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring;

import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.util.StringUtil;
import com.mybatisflex.spring.TimeoutHolder;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.transaction.Transaction;

public class FlexSpringTransaction
implements Transaction {
    private final FlexDataSource dataSource;
    private Boolean isConnectionTransactional;
    private Boolean autoCommit;
    private Connection connection;

    public FlexSpringTransaction(FlexDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        if (this.isConnectionTransactional == null) {
            this.connection = this.dataSource.getConnection();
            this.isConnectionTransactional = StringUtil.hasText((String)TransactionContext.getXID());
            this.autoCommit = this.connection.getAutoCommit();
            return this.connection;
        }
        if (this.isConnectionTransactional.booleanValue()) {
            return this.dataSource.getConnection();
        }
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional.booleanValue() && !this.autoCommit.booleanValue()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional.booleanValue() && !this.autoCommit.booleanValue()) {
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional.booleanValue()) {
            this.connection.close();
        }
    }

    public Integer getTimeout() throws SQLException {
        return TimeoutHolder.getTimeToLiveInSeconds();
    }
}

