/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring;

import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.transaction.TransactionalManager;
import com.mybatisflex.core.util.StringUtil;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class FlexTransactionManager
extends AbstractPlatformTransactionManager {
    protected Object doGetTransaction() throws TransactionException {
        return new TransactionObject(TransactionContext.getXID());
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)transaction;
        return StringUtil.isNotBlank((String)transactionObject.prevXid);
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        TransactionContext.release();
        TransactionObject transactionObject = (TransactionObject)transaction;
        return transactionObject.prevXid;
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        String xid = (String)suspendedResources;
        TransactionContext.holdXID((String)xid);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)transaction;
        transactionObject.currentXid = TransactionalManager.startTransactional();
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)status.getTransaction();
        TransactionalManager.commit((String)transactionObject.currentXid);
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)status.getTransaction();
        TransactionalManager.rollback((String)transactionObject.currentXid);
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
    }

    static class TransactionObject {
        private final String prevXid;
        private String currentXid;

        public TransactionObject(String prevXid) {
            this.prevXid = prevXid;
        }
    }
}

