/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.FieldHandler;
import com.mycila.guice.ext.injection.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class FieldHandlerTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends FieldHandler<A>> handlerClass;

    public FieldHandlerTypeListener(Class<A> annotationType, Class<? extends FieldHandler<A>> handlerClass) {
        this.annotationType = annotationType;
        this.handlerClass = handlerClass;
    }

    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Provider provider = encounter.getProvider(this.handlerClass);
        final LinkedList fields = Lists.newLinkedList(Reflect.findAllAnnotatedFields(type.getRawType(), this.annotationType));
        if (!fields.isEmpty()) {
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    FieldHandler handler = (FieldHandler)provider.get();
                    for (Field field : fields) {
                        handler.handle(type, injectee, field, field.getAnnotation(FieldHandlerTypeListener.this.annotationType));
                    }
                }
            });
        }
    }
}

