/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.FieldHandler;
import com.mycila.guice.ext.injection.FieldHandlerTypeListener;
import com.mycila.guice.ext.injection.KeyProvider;
import com.mycila.guice.ext.injection.MemberInjectorTypeListener;
import com.mycila.guice.ext.injection.MethodHandler;
import com.mycila.guice.ext.injection.MethodHandlerTypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

public class MBinder
implements Binder {
    private final Binder binder;

    private MBinder(Binder binder) {
        this.binder = binder;
    }

    public <A extends Annotation> MBinder bindAnnotationInjector(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.willInject(new MemberInjectorTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MBinder handleMethodAfterInjection(Class<A> annotationType, Class<? extends MethodHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.willInject(new MethodHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MBinder handleFieldAfterInjection(Class<A> annotationType, Class<? extends FieldHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.willInject(new FieldHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <T> T willInject(T object) {
        this.binder.requestInjection(object);
        return object;
    }

    public static MBinder wrap(Binder binder) {
        return new MBinder(binder);
    }

    public void addError(Message message) {
        this.binder.addError(message);
    }

    public void addError(String message, Object ... arguments) {
        this.binder.addError(message, arguments);
    }

    public void addError(Throwable t) {
        this.binder.addError(t);
    }

    public <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        return this.binder.bind(key);
    }

    public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
        return this.binder.bind(type);
    }

    public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder.bind(typeLiteral);
    }

    public AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder.bindConstant();
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        for (MethodInterceptor interceptor : interceptors) {
            this.requestInjection(interceptor);
        }
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
    }

    public void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder.bindListener(typeMatcher, listener);
    }

    public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
        this.binder.bindScope(annotationType, scope);
    }

    public void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder.convertToTypes(typeMatcher, converter);
    }

    public Stage currentStage() {
        return this.binder.currentStage();
    }

    public void disableCircularProxies() {
        this.binder.disableCircularProxies();
    }

    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.binder.getMembersInjector(type);
    }

    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return this.binder.getMembersInjector(typeLiteral);
    }

    public <T> Provider<T> getProvider(Key<T> key) {
        return this.binder.getProvider(key);
    }

    public <T> Provider<T> getProvider(Class<T> type) {
        return this.binder.getProvider(type);
    }

    public void install(Module module) {
        this.binder.install(module);
    }

    public PrivateBinder newPrivateBinder() {
        return this.binder.newPrivateBinder();
    }

    public void requestInjection(Object instance) {
        this.binder.requestInjection(instance);
    }

    public <T> void requestInjection(TypeLiteral<T> type, T instance) {
        this.binder.requestInjection(type, instance);
    }

    public void requestStaticInjection(Class<?> ... types) {
        this.binder.requestStaticInjection((Class[])types);
    }

    public void requireExplicitBindings() {
        this.binder.requireExplicitBindings();
    }

    public Binder skipSources(Class ... classesToSkip) {
        return this.binder.skipSources(classesToSkip);
    }

    public Binder withSource(Object source) {
        return this.binder.withSource(source);
    }

    public void bindListener(Matcher<? super Binding<?>> bindingMatcher, ProvisionListener ... listeners) {
        this.binder.bindListener(bindingMatcher, listeners);
    }

    public void requireAtInjectOnConstructors() {
        this.binder.requireAtInjectOnConstructors();
    }

    public void requireExactBindingAnnotations() {
        this.binder.requireExactBindingAnnotations();
    }

    public <T> Provider<T> getProvider(Dependency<T> dpndnc) {
        return this.binder.getProvider(dpndnc);
    }

    public void scanModulesForAnnotatedMethods(ModuleAnnotatedMethodScanner mams) {
        this.binder.scanModulesForAnnotatedMethods(mams);
    }
}

