/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.MethodHandler;
import com.mycila.guice.ext.injection.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

public class MethodHandlerTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends MethodHandler<A>> handlerClass;

    public MethodHandlerTypeListener(Class<A> annotationType, Class<? extends MethodHandler<A>> handlerClass) {
        this.annotationType = annotationType;
        this.handlerClass = handlerClass;
    }

    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Provider provider = encounter.getProvider(this.handlerClass);
        final List methods = Lists.reverse((List)Lists.newLinkedList(Reflect.findAllAnnotatedMethods(type.getRawType(), this.annotationType)));
        if (!methods.isEmpty()) {
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    MethodHandler handler = (MethodHandler)provider.get();
                    for (Method method : methods) {
                        handler.handle(type, injectee, method, method.getAnnotation(MethodHandlerTypeListener.this.annotationType));
                    }
                }
            });
        }
    }
}

