/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.git.GitLookup;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class CopyrightRangeProvider
implements PropertiesProvider {
    public static final String COPYRIGHT_LAST_YEAR_KEY = "license.git.copyrightLastYear";
    public static final String COPYRIGHT_LAST_YEAR_MAX_COMMITS_LOOKUP_KEY = "license.git.copyrightLastYearMaxCommitsLookup";
    public static final String COPYRIGHT_LAST_YEAR_SOURCE_KEY = "license.git.copyrightLastYearSource";
    public static final String COPYRIGHT_LAST_YEAR_TIME_ZONE_KEY = "license.git.copyrightLastYearTimeZone";
    public static final String COPYRIGHT_YEARS_KEY = "license.git.copyrightYears";
    public static final String INCEPTION_YEAR_KEY = "project.inceptionYear";
    private volatile GitLookup gitLookup;

    public Map<String, String> getAdditionalProperties(AbstractLicenseMojo mojo, Properties properties, Document document) {
        int inceptionYearInt;
        String inceptionYear = properties.getProperty(INCEPTION_YEAR_KEY);
        if (inceptionYear == null) {
            throw new RuntimeException("'project.inceptionYear' must have a value for file " + document.getFile().getAbsolutePath());
        }
        try {
            inceptionYearInt = Integer.parseInt(inceptionYear);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("'project.inceptionYear' must be an integer ; found = " + inceptionYear + " file: " + document.getFile().getAbsolutePath());
        }
        try {
            HashMap<String, String> result = new HashMap<String, String>(3);
            int copyrightEnd = this.getGitLookup(document.getFile(), properties).getYearOfLastChange(document.getFile());
            result.put(COPYRIGHT_LAST_YEAR_KEY, Integer.toString(copyrightEnd));
            String copyrightYears = inceptionYearInt >= copyrightEnd ? inceptionYear : String.valueOf(inceptionYear) + "-" + copyrightEnd;
            result.put(COPYRIGHT_YEARS_KEY, copyrightYears);
            return Collections.unmodifiableMap(result);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not compute the year of the last git commit for file " + document.getFile().getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitLookup getGitLookup(File file, Properties props) throws IOException {
        if (this.gitLookup == null) {
            CopyrightRangeProvider copyrightRangeProvider = this;
            synchronized (copyrightRangeProvider) {
                if (this.gitLookup == null) {
                    TimeZone timeZone;
                    String dateSourceString = props.getProperty(COPYRIGHT_LAST_YEAR_SOURCE_KEY, GitLookup.DateSource.AUTHOR.name());
                    GitLookup.DateSource dateSource = GitLookup.DateSource.valueOf(dateSourceString.toUpperCase(Locale.US));
                    String checkCommitsCountString = props.getProperty(COPYRIGHT_LAST_YEAR_MAX_COMMITS_LOOKUP_KEY);
                    int checkCommitsCount = 10;
                    if (checkCommitsCountString != null) {
                        checkCommitsCountString = checkCommitsCountString.trim();
                        checkCommitsCount = Integer.parseInt(checkCommitsCountString);
                    }
                    String tzString = props.getProperty(COPYRIGHT_LAST_YEAR_TIME_ZONE_KEY);
                    switch (dateSource) {
                        case COMMITER: {
                            timeZone = tzString == null ? GitLookup.DEFAULT_ZONE : TimeZone.getTimeZone(tzString);
                            break;
                        }
                        case AUTHOR: {
                            if (tzString != null) {
                                throw new RuntimeException("license.git.copyrightLastYearTimeZone must not be set with license.git.copyrightLastYearSource = " + GitLookup.DateSource.AUTHOR.name() + " because git author name already contrains time zone information.");
                            }
                            timeZone = null;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected " + GitLookup.DateSource.class.getName() + " " + (Object)((Object)dateSource));
                        }
                    }
                    this.gitLookup = new GitLookup(file, dateSource, timeZone, checkCommitsCount);
                }
            }
        }
        return this.gitLookup;
    }
}

