/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.git.GitLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;

public class CopyrightRangeProvider
implements PropertiesProvider {
    public static final String COPYRIGHT_LAST_YEAR_KEY = "license.git.copyrightLastYear";
    public static final String COPYRIGHT_CREATION_YEAR_KEY = "license.git.copyrightCreationYear";
    public static final String COPYRIGHT_EXISTENCE_YEARS_KEY = "license.git.copyrightExistenceYears";
    public static final String COPYRIGHT_YEARS_KEY = "license.git.copyrightYears";
    public static final String INCEPTION_YEAR_KEY = "project.inceptionYear";
    private GitLookup gitLookup;

    public void init(AbstractLicenseMojo mojo, Map<String, String> currentProperties) {
        this.gitLookup = GitLookup.create(mojo.defaultBasedir, currentProperties);
        if (mojo.warnIfShallow && this.gitLookup.isShallowRepository()) {
            mojo.warn("Shallow git repository detected. Year property values may not be accurate.", new Object[0]);
        }
    }

    public void close() {
        if (this.gitLookup != null) {
            this.gitLookup.close();
        }
    }

    public Map<String, String> adjustProperties(AbstractLicenseMojo mojo, Map<String, String> properties, Document document) {
        int inceptionYearInt;
        String inceptionYear = properties.get(INCEPTION_YEAR_KEY);
        if (inceptionYear == null) {
            throw new RuntimeException("'project.inceptionYear' must have a value for file " + document.getFile().getAbsolutePath());
        }
        try {
            inceptionYearInt = Integer.parseInt(inceptionYear);
        }
        catch (NumberFormatException e1) {
            throw new RuntimeException("'project.inceptionYear' must be an integer ; found = " + inceptionYear + " file: " + document.getFile().getAbsolutePath());
        }
        try {
            HashMap<String, String> result = new HashMap<String, String>(4);
            int copyrightEnd = this.gitLookup.getYearOfLastChange(document.getFile());
            result.put(COPYRIGHT_LAST_YEAR_KEY, Integer.toString(copyrightEnd));
            String copyrightYears = inceptionYearInt >= copyrightEnd ? inceptionYear : inceptionYear + "-" + copyrightEnd;
            result.put(COPYRIGHT_YEARS_KEY, copyrightYears);
            int copyrightStart = this.gitLookup.getYearOfCreation(document.getFile());
            result.put(COPYRIGHT_CREATION_YEAR_KEY, Integer.toString(copyrightStart));
            String copyrightExistenceYears = copyrightStart >= copyrightEnd ? Integer.toString(copyrightStart) : copyrightStart + "-" + copyrightEnd;
            result.put(COPYRIGHT_EXISTENCE_YEARS_KEY, copyrightExistenceYears);
            return Collections.unmodifiableMap(result);
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException("CopyrightRangeProvider error on file: " + document.getFile().getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }
}

