/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.git.GitLookup;
import com.mycila.maven.plugin.license.util.Fn;
import com.mycila.maven.plugin.license.util.LazyMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;

public class CopyrightAuthorProvider
implements PropertiesProvider {
    public static final String COPYRIGHT_CREATION_AUTHOR_NAME_KEY = "license.git.CreationAuthorName";
    public static final String COPYRIGHT_CREATION_AUTHOR_EMAIL_KEY = "license.git.CreationAuthorEmail";
    private GitLookup gitLookup;

    public void init(AbstractLicenseMojo mojo, Map<String, String> currentProperties) {
        this.gitLookup = GitLookup.create(mojo.defaultBasedir, currentProperties);
        if (mojo.warnIfShallow && this.gitLookup.isShallowRepository()) {
            mojo.warn("Shallow git repository detected. Author property values may not be accurate.", new Object[0]);
        }
    }

    public void close() {
        if (this.gitLookup != null) {
            this.gitLookup.close();
        }
    }

    public Map<String, String> adjustProperties(AbstractLicenseMojo mojo, Map<String, String> properties, Document document) {
        LazyMap result = new LazyMap(2);
        result.putSupplier((Object)COPYRIGHT_CREATION_AUTHOR_NAME_KEY, Fn.memoize(() -> {
            try {
                return this.gitLookup.getAuthorNameOfCreation(document.getFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException("CopyrightAuthorProvider error on file: " + document.getFile().getAbsolutePath() + ": " + e.getMessage(), e);
            }
        }));
        result.putSupplier((Object)COPYRIGHT_CREATION_AUTHOR_EMAIL_KEY, Fn.memoize(() -> {
            try {
                return this.gitLookup.getAuthorEmailOfCreation(document.getFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException("CopyrightAuthorProvider error on file: " + document.getFile().getAbsolutePath() + ": " + e.getMessage(), e);
            }
        }));
        return Collections.unmodifiableMap(result);
    }
}

