/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.git.GitLookup;
import com.mycila.maven.plugin.license.util.Fn;
import com.mycila.maven.plugin.license.util.LazyMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.jgit.api.errors.GitAPIException;

public class CopyrightRangeProvider
implements PropertiesProvider {
    public static final String COPYRIGHT_LAST_YEAR_KEY = "license.git.copyrightLastYear";
    public static final String COPYRIGHT_CREATION_YEAR_KEY = "license.git.copyrightCreationYear";
    public static final String COPYRIGHT_EXISTENCE_YEARS_KEY = "license.git.copyrightExistenceYears";
    public static final String COPYRIGHT_YEARS_KEY = "license.git.copyrightYears";
    public static final String INCEPTION_YEAR_KEY = "project.inceptionYear";
    private GitLookup gitLookup;

    public void init(AbstractLicenseMojo mojo, Map<String, String> currentProperties) {
        this.gitLookup = GitLookup.create(mojo.defaultBasedir, currentProperties);
        if (mojo.warnIfShallow && this.gitLookup.isShallowRepository()) {
            mojo.warn("Shallow git repository detected. Year property values may not be accurate.", new Object[0]);
        }
    }

    public void close() {
        if (this.gitLookup != null) {
            this.gitLookup.close();
        }
    }

    public Map<String, String> adjustProperties(AbstractLicenseMojo mojo, Map<String, String> properties, Document document) {
        Supplier inceptionYear = Fn.memoize(() -> {
            String year = (String)properties.get(INCEPTION_YEAR_KEY);
            if (year == null) {
                throw new RuntimeException("'project.inceptionYear' must have a value for file " + document.getFile().getAbsolutePath());
            }
            try {
                return Integer.parseInt(year);
            }
            catch (NumberFormatException e1) {
                throw new RuntimeException("'project.inceptionYear' must be an integer ; found = " + year + " file: " + document.getFile().getAbsolutePath());
            }
        });
        Supplier copyrightEnd = Fn.memoize(() -> {
            try {
                return this.gitLookup.getYearOfLastChange(document.getFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(document.getFile().getAbsolutePath(), e);
            }
            catch (GitAPIException e) {
                throw new RuntimeException(document.getFile().getAbsolutePath(), e);
            }
        });
        Supplier copyrightStart = Fn.memoize(() -> {
            try {
                return this.gitLookup.getYearOfCreation(document.getFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(document.getFile().getAbsolutePath(), e);
            }
        });
        LazyMap result = new LazyMap(4);
        result.putSupplier((Object)COPYRIGHT_CREATION_YEAR_KEY, Fn.memoize(() -> CopyrightRangeProvider.lambda$adjustProperties$3((Supplier)copyrightStart)));
        result.putSupplier((Object)COPYRIGHT_LAST_YEAR_KEY, Fn.memoize(() -> CopyrightRangeProvider.lambda$adjustProperties$4((Supplier)copyrightEnd)));
        result.putSupplier((Object)COPYRIGHT_YEARS_KEY, Fn.memoize(() -> CopyrightRangeProvider.lambda$adjustProperties$5((Supplier)inceptionYear, (Supplier)copyrightEnd)));
        result.putSupplier((Object)COPYRIGHT_EXISTENCE_YEARS_KEY, Fn.memoize(() -> CopyrightRangeProvider.lambda$adjustProperties$6((Supplier)copyrightStart, (Supplier)copyrightEnd)));
        return result;
    }

    private static /* synthetic */ String lambda$adjustProperties$6(Supplier copyrightStart, Supplier copyrightEnd) {
        Object copyrightExistenceYears = (Integer)copyrightStart.get() >= (Integer)copyrightEnd.get() ? Integer.toString((Integer)copyrightStart.get()) : copyrightStart.get() + "-" + copyrightEnd.get();
        return copyrightExistenceYears;
    }

    private static /* synthetic */ String lambda$adjustProperties$5(Supplier inceptionYear, Supplier copyrightEnd) {
        String copyrightYears = (Integer)inceptionYear.get() >= (Integer)copyrightEnd.get() ? "" + inceptionYear.get() : inceptionYear.get() + "-" + copyrightEnd.get();
        return copyrightYears;
    }

    private static /* synthetic */ String lambda$adjustProperties$4(Supplier copyrightEnd) {
        return ((Integer)copyrightEnd.get()).toString();
    }

    private static /* synthetic */ String lambda$adjustProperties$3(Supplier copyrightStart) {
        return ((Integer)copyrightStart.get()).toString();
    }
}

