/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.git.GitPathResolver;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitLookup
implements AutoCloseable {
    public static final TimeZone DEFAULT_ZONE = TimeZone.getTimeZone("GMT");
    public static final String MAX_COMMITS_LOOKUP_KEY = "license.git.maxCommitsLookup";
    private static final String COPYRIGHT_LAST_YEAR_MAX_COMMITS_LOOKUP_KEY = "license.git.copyrightLastYearMaxCommitsLookup";
    public static final String COPYRIGHT_LAST_YEAR_SOURCE_KEY = "license.git.copyrightLastYearSource";
    public static final String COPYRIGHT_LAST_YEAR_TIME_ZONE_KEY = "license.git.copyrightLastYearTimeZone";
    public static final String COMMITS_TO_IGNORE_KEY = "license.git.commitsToIgnore";
    private final int checkCommitsCount;
    private final DateSource dateSource;
    private final GitPathResolver pathResolver;
    private final Repository repository;
    private final TimeZone timeZone;
    private final boolean shallow;
    private final Set<ObjectId> commitsToIgnore;

    public static GitLookup create(File file, Map<String, String> props) {
        DateSource dateSource = Optional.ofNullable(props.get(COPYRIGHT_LAST_YEAR_SOURCE_KEY)).map(String::trim).map(String::toUpperCase).map(DateSource::valueOf).orElse(DateSource.AUTHOR);
        int checkCommitsCount = Stream.of(MAX_COMMITS_LOOKUP_KEY, COPYRIGHT_LAST_YEAR_MAX_COMMITS_LOOKUP_KEY).map(props::get).filter(Objects::nonNull).map(String::trim).map(Integer::parseInt).findFirst().orElse(Integer.MAX_VALUE);
        Set<ObjectId> commitsToIgnore = Stream.of(COMMITS_TO_IGNORE_KEY).map(props::get).filter(Objects::nonNull).flatMap(s -> Stream.of(s.split(","))).map(String::trim).filter(s -> !s.isEmpty()).map(ObjectId::fromString).collect(Collectors.toSet());
        TimeZone timeZone = Optional.ofNullable(props.get(COPYRIGHT_LAST_YEAR_TIME_ZONE_KEY)).map(String::trim).map(TimeZone::getTimeZone).orElse(DEFAULT_ZONE);
        return new GitLookup(file, dateSource, timeZone, checkCommitsCount, commitsToIgnore);
    }

    private GitLookup(File anyFile, DateSource dateSource, TimeZone timeZone, int checkCommitsCount, Set<ObjectId> commitsToIgnore) {
        Objects.requireNonNull(anyFile);
        Objects.requireNonNull(dateSource);
        Objects.requireNonNull(timeZone);
        Objects.requireNonNull(commitsToIgnore);
        try {
            this.repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(anyFile)).build();
            try (ObjectReader objectReader = this.repository.getObjectDatabase().newReader();){
                this.shallow = !objectReader.getShallowCommits().isEmpty();
            }
            this.pathResolver = new GitPathResolver(this.repository.getWorkTree().getAbsolutePath());
            this.dateSource = dateSource;
            this.timeZone = timeZone;
            this.checkCommitsCount = checkCommitsCount;
            this.commitsToIgnore = commitsToIgnore;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    int getYearOfLastChange(File file) throws GitAPIException, IOException {
        String repoRelativePath = this.pathResolver.relativize(file);
        if (this.isFileModifiedOrUnstaged(repoRelativePath)) {
            return this.getCurrentYear();
        }
        int commitYear = 0;
        RevWalk walk = this.getGitRevWalk(repoRelativePath, false);
        for (RevCommit commit : walk) {
            int y;
            if (this.commitsToIgnore.contains(commit.getId()) || (y = this.getYearFromCommit(commit)) <= commitYear) continue;
            commitYear = y;
        }
        walk.dispose();
        return commitYear;
    }

    int getYearOfCreation(File file) throws IOException {
        String repoRelativePath = this.pathResolver.relativize(file);
        int commitYear = 0;
        RevWalk walk = this.getGitRevWalk(repoRelativePath, true);
        Iterator iterator = walk.iterator();
        if (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            commitYear = this.getYearFromCommit(commit);
        }
        walk.dispose();
        if (commitYear == 0) {
            return this.getCurrentYear();
        }
        return commitYear;
    }

    String getAuthorNameOfCreation(File file) throws IOException {
        String repoRelativePath = this.pathResolver.relativize(file);
        String authorName = "";
        RevWalk walk = this.getGitRevWalk(repoRelativePath, true);
        Iterator iterator = walk.iterator();
        if (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            authorName = this.getAuthorNameFromCommit(commit);
        }
        walk.dispose();
        return authorName;
    }

    String getAuthorEmailOfCreation(File file) throws IOException {
        String repoRelativePath = this.pathResolver.relativize(file);
        String authorEmail = "";
        RevWalk walk = this.getGitRevWalk(repoRelativePath, true);
        Iterator iterator = walk.iterator();
        if (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            authorEmail = this.getAuthorEmailFromCommit(commit);
        }
        walk.dispose();
        return authorEmail;
    }

    boolean isShallowRepository() {
        return this.shallow;
    }

    private boolean isFileModifiedOrUnstaged(String repoRelativePath) throws GitAPIException {
        Status status = null;
        try (Git git = new Git(this.repository);){
            status = git.status().addPath(repoRelativePath).call();
        }
        return !status.isClean();
    }

    private RevWalk getGitRevWalk(String repoRelativePath, boolean oldestCommitsFirst) throws IOException {
        DiffConfig diffConfig = (DiffConfig)this.repository.getConfig().get(DiffConfig.KEY);
        RevWalk walk = new RevWalk(this.repository);
        walk.markStart(walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD")));
        walk.setTreeFilter(AndTreeFilter.create(Arrays.asList(PathFilter.create((String)repoRelativePath), FollowFilter.create((String)repoRelativePath, (DiffConfig)diffConfig), TreeFilter.ANY_DIFF)));
        walk.setRevFilter(MaxCountRevFilter.create((int)this.checkCommitsCount));
        walk.setRetainBody(false);
        if (oldestCommitsFirst) {
            walk.sort(RevSort.REVERSE);
        }
        return walk;
    }

    private int getCurrentYear() {
        return GitLookup.toYear(System.currentTimeMillis(), this.timeZone);
    }

    private int getYearFromCommit(RevCommit commit) {
        switch (this.dateSource) {
            case COMMITER: {
                int epochSeconds = commit.getCommitTime();
                return GitLookup.toYear((long)epochSeconds * 1000L, this.timeZone);
            }
            case AUTHOR: {
                PersonIdent id = commit.getAuthorIdent();
                Date date = id.getWhen();
                return GitLookup.toYear(date.getTime(), id.getTimeZone());
            }
        }
        throw new IllegalStateException("Unexpected " + DateSource.class.getName() + " " + this.dateSource);
    }

    private static int toYear(long epochMilliseconds, TimeZone timeZone) {
        Calendar result = Calendar.getInstance(timeZone);
        result.setTimeInMillis(epochMilliseconds);
        return result.get(1);
    }

    private String getAuthorNameFromCommit(RevCommit commit) {
        PersonIdent id = commit.getAuthorIdent();
        return id.getName();
    }

    private String getAuthorEmailFromCommit(RevCommit commit) {
        PersonIdent id = commit.getAuthorIdent();
        return id.getEmailAddress();
    }

    @Override
    public void close() {
        this.repository.close();
    }

    public static enum DateSource {
        AUTHOR,
        COMMITER;

    }
}

