/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public final class FileUtils {
    private FileUtils() {
    }

    public static void write(File file, String content, String encoding) throws IOException {
        FileChannel channel = new FileOutputStream(file).getChannel();
        try {
            channel.write(ByteBuffer.wrap(content.getBytes(encoding)));
        }
        finally {
            channel.close();
        }
    }

    public static String read(URL location, String encoding, Map<String, String> properties) throws IOException {
        InterpolationFilterReader reader = new InterpolationFilterReader((Reader)new BufferedReader(new InputStreamReader(location.openStream(), encoding)), properties);
        try {
            String string = IOUtil.toString((Reader)reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String read(URL location, String encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(location.openStream(), encoding));
        try {
            String string = IOUtil.toString((Reader)reader);
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public static String read(File file, String encoding) throws IOException {
        FileChannel in = new FileInputStream(file).getChannel();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            in.transferTo(0L, in.size(), Channels.newChannel(baos));
            String string = baos.toString(encoding);
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String readFirstLines(File file, int lineCount, String encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while (lineCount > 0 && (line = reader.readLine()) != null) {
                --lineCount;
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String remove(String str, String ... chars) {
        String[] stringArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            str = str.replace(s, "");
            ++n2;
        }
        return str;
    }

    public static void copyFileToFolder(File file, File folder) throws IOException {
        File dest = new File(folder, file.getName());
        FileChannel inChannel = new FileInputStream(file).getChannel();
        FileChannel outChannel = new FileOutputStream(dest).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

