/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.util;

import com.mycila.maven.plugin.license.util.FileUtils;
import java.io.File;
import java.io.IOException;

public final class FileContent {
    private final File file;
    private final StringBuilder fileContent;
    private final boolean unix;
    private int oldPos;
    private int position;

    public FileContent(File file, String encoding) {
        try {
            this.file = file;
            this.fileContent = new StringBuilder(FileUtils.read(file, encoding));
            this.unix = this.fileContent.indexOf("\r") == -1;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file " + file + ". Cause: " + e.getMessage(), e);
        }
    }

    public void resetTo(int pos) {
        this.oldPos = this.position;
        this.position = pos;
    }

    public void reset() {
        this.oldPos = this.position;
        this.position = 0;
    }

    public void rewind() {
        this.position = this.oldPos;
    }

    public boolean endReached() {
        return this.position >= this.fileContent.length();
    }

    public String nextLine() {
        if (this.endReached()) {
            return null;
        }
        int lf = this.fileContent.indexOf("\n", this.position);
        int eol = lf == -1 || lf == 0 ? this.fileContent.length() : (this.fileContent.charAt(lf - 1) == '\r' ? lf - 1 : lf);
        String str = this.fileContent.substring(this.position, eol);
        this.oldPos = this.position;
        this.position = lf == -1 ? this.fileContent.length() : lf + 1;
        return str;
    }

    public int getPosition() {
        return this.position;
    }

    public void delete(int start, int end) {
        this.fileContent.delete(start, end);
    }

    public void insert(int index, String str) {
        this.fileContent.insert(index, str);
    }

    public void removeDuplicatedEmptyEndLines() {
        int pos;
        while ((pos = this.fileContent.lastIndexOf("\n")) != -1) {
            boolean cr = false;
            if (pos > 0 && this.fileContent.charAt(pos - 1) == '\r') {
                cr = true;
                --pos;
            }
            if (pos <= 0 || this.fileContent.charAt(pos - 1) != '\n') break;
            this.fileContent.deleteCharAt(pos);
            if (!cr) continue;
            this.fileContent.deleteCharAt(pos);
        }
        this.oldPos = this.position;
        this.position = this.fileContent.length();
    }

    public String getContent() {
        return this.fileContent.toString();
    }

    public boolean isUnix() {
        return this.unix;
    }

    public String toString() {
        return this.file.toString();
    }
}

