/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.Callback;
import com.mycila.maven.plugin.license.Credentials;
import com.mycila.maven.plugin.license.HeaderSection;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.document.DocumentFactory;
import com.mycila.maven.plugin.license.document.DocumentPropertiesLoader;
import com.mycila.maven.plugin.license.document.DocumentType;
import com.mycila.maven.plugin.license.header.AdditionalHeaderDefinition;
import com.mycila.maven.plugin.license.header.Header;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.header.HeaderSource;
import com.mycila.maven.plugin.license.header.HeaderType;
import com.mycila.maven.plugin.license.util.Selection;
import com.mycila.maven.plugin.license.util.resource.ResourceFinder;
import com.mycila.xmltool.XMLDoc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.xml.sax.InputSource;

public abstract class AbstractLicenseMojo
extends AbstractMojo {
    @Parameter(property="license.basedir", defaultValue="${basedir}", required=true)
    public File basedir;
    @Parameter(property="license.header")
    public String header;
    @Parameter(property="license.inlineHeader")
    public String inlineHeader;
    @Parameter
    public String[] validHeaders = new String[0];
    @Parameter
    public String[] headerDefinitions = new String[0];
    @Parameter
    public HeaderSection[] headerSections = new HeaderSection[0];
    @Parameter
    public Map<String, String> properties = new HashMap<String, String>();
    @Parameter
    public String[] includes = new String[0];
    @Parameter
    public String[] excludes = new String[0];
    @Parameter
    public String[] keywords = new String[]{"copyright"};
    @Parameter(property="license.useDefaultExcludes", defaultValue="true")
    public boolean useDefaultExcludes = true;
    @Parameter(property="license.aggregate", defaultValue="false")
    public boolean aggregate = false;
    @Parameter
    public LinkedHashMap<String, String> mapping = new LinkedHashMap();
    @Parameter(property="license.useDefaultMapping", defaultValue="true")
    public boolean useDefaultMapping = true;
    @Parameter(property="license.concurrencyFactor", defaultValue="1.5")
    public float concurrencyFactor = 1.5f;
    @Parameter(property="license.skip", defaultValue="false")
    public boolean skip = false;
    @Parameter(property="license.quiet", defaultValue="false")
    public boolean quiet = false;
    @Parameter(property="license.strictCheck", defaultValue="true")
    public boolean strictCheck = true;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    public String encoding = "UTF-8";
    @Parameter(property="license.failIfMissing", defaultValue="true")
    public boolean failIfMissing = true;
    @Parameter(property="license.failIfUnknown", defaultValue="false")
    public boolean failIfUnknown = false;
    @Parameter(property="license.dryRun", defaultValue="false")
    public boolean dryRun = false;
    @Parameter(property="license.skipExistingHeaders", defaultValue="false")
    public boolean skipExistingHeaders = false;
    @Component
    public MavenProject project;
    @Component
    private Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;
    private ResourceFinder finder;

    public final void execute(final Callback callback) throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (this.header == null && (this.inlineHeader == null || this.inlineHeader.isEmpty())) {
                this.warn("No header file specified to check for license", new Object[0]);
                return;
            }
            if (!this.strictCheck) {
                this.warn("Property 'strictCheck' is not enabled. Please consider adding <strictCheck>true</strictCheck> in your pom.xml file.", new Object[0]);
                this.warn("See http://mycila.github.io/license-maven-plugin for more information.", new Object[0]);
            }
            this.finder = new ResourceFinder(this.basedir);
            try {
                this.finder.setCompileClassPath(this.project.getCompileClasspathElements());
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            this.finder.setPluginClassPath(((Object)((Object)this)).getClass().getClassLoader());
            HeaderSource headerSource = HeaderSource.of(this.inlineHeader, this.header, this.encoding, this.finder);
            final Header h = new Header(headerSource, this.headerSections);
            this.debug("Header: %s", h.getLocation());
            if (this.validHeaders == null) {
                this.validHeaders = new String[0];
            }
            final ArrayList<Header> validHeaders = new ArrayList<Header>(this.validHeaders.length);
            String[] stringArray = this.validHeaders;
            int n = this.validHeaders.length;
            int n2 = 0;
            while (n2 < n) {
                String validHeader = stringArray[n2];
                HeaderSource validHeaderSource = HeaderSource.of(null, validHeader, this.encoding, this.finder);
                validHeaders.add(new Header(validHeaderSource, this.headerSections));
                ++n2;
            }
            final LinkedList<PropertiesProvider> propertiesProviders = new LinkedList<PropertiesProvider>();
            for (PropertiesProvider provider : ServiceLoader.load(PropertiesProvider.class, Thread.currentThread().getContextClassLoader())) {
                propertiesProviders.add(provider);
            }
            DocumentPropertiesLoader propertiesLoader = new DocumentPropertiesLoader(){

                @Override
                public Properties load(Document document) {
                    Properties props = new Properties();
                    for (Map.Entry entry : AbstractLicenseMojo.this.mergeProperties(document).entrySet()) {
                        if (entry.getValue() != null) {
                            props.setProperty((String)entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        props.remove(entry.getKey());
                    }
                    for (PropertiesProvider provider : propertiesProviders) {
                        try {
                            Map<String, String> providerProperties = provider.getAdditionalProperties(AbstractLicenseMojo.this, props, document);
                            if (AbstractLicenseMojo.this.getLog().isDebugEnabled()) {
                                AbstractLicenseMojo.this.getLog().debug((CharSequence)("provider: " + provider.getClass() + " brought new properties\n" + providerProperties));
                            }
                            for (Map.Entry<String, String> entry : providerProperties.entrySet()) {
                                if (entry.getValue() != null) {
                                    props.setProperty(entry.getKey(), entry.getValue());
                                    continue;
                                }
                                props.remove(entry.getKey());
                            }
                        }
                        catch (Exception e) {
                            AbstractLicenseMojo.this.getLog().warn((CharSequence)("failure occured while calling " + provider.getClass()), (Throwable)e);
                        }
                    }
                    return props;
                }
            };
            final DocumentFactory documentFactory = new DocumentFactory(this.basedir, this.buildMapping(), this.buildHeaderDefinitions(), this.encoding, this.keywords, propertiesLoader);
            int nThreads = (int)((float)Runtime.getRuntime().availableProcessors() * this.concurrencyFactor);
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
            ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
            int count = 0;
            this.debug("Number of execution threads: %s", nThreads);
            try {
                String[] stringArray2 = this.listSelectedFiles();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    final String file = stringArray2[n4];
                    completionService.submit(new Runnable(){

                        @Override
                        public void run() {
                            Document document = documentFactory.createDocuments(file);
                            AbstractLicenseMojo.this.debug("Selected file: %s [header style: %s]", document.getFilePath(), document.getHeaderDefinition());
                            if (document.isNotSupported()) {
                                callback.onUnknownFile(document, h);
                            } else if (document.is(h)) {
                                AbstractLicenseMojo.this.debug("Skipping header file: %s", document.getFilePath());
                            } else if (document.hasHeader(h, AbstractLicenseMojo.this.strictCheck)) {
                                callback.onExistingHeader(document, h);
                            } else {
                                boolean headerFound = false;
                                for (Header validHeader : validHeaders) {
                                    headerFound = document.hasHeader(validHeader, AbstractLicenseMojo.this.strictCheck);
                                    if (!headerFound) continue;
                                    callback.onExistingHeader(document, h);
                                    break;
                                }
                                if (!headerFound) {
                                    callback.onHeaderNotFound(document, h);
                                }
                            }
                        }
                    }, null);
                    ++count;
                    ++n4;
                }
                while (count-- > 0) {
                    try {
                        completionService.take().get();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        if (cause instanceof MojoExecutionException) {
                            throw (MojoExecutionException)cause;
                        }
                        if (cause instanceof MojoFailureException) {
                            throw (MojoFailureException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new RuntimeException(cause.getMessage(), cause);
                    }
                }
            }
            finally {
                executorService.shutdownNow();
            }
        }
    }

    private Map<String, String> mergeProperties(Document document) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(System.getenv());
        props.put("project.groupId", this.project.getGroupId());
        props.put("project.artifactId", this.project.getArtifactId());
        props.put("project.version", this.project.getVersion());
        props.put("project.name", this.project.getName());
        props.put("project.description", this.project.getDescription());
        props.put("project.inceptionYear", this.project.getInceptionYear());
        props.put("project.url", this.project.getUrl());
        props.put("file.name", document.getFile().getName());
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        for (String key : System.getProperties().stringPropertyNames()) {
            props.put(key, System.getProperty(key));
        }
        return props;
    }

    private String[] listSelectedFiles() {
        Selection selection = new Selection(this.basedir, this.includes, this.buildExcludes(), this.useDefaultExcludes);
        this.debug("From: %s", this.basedir);
        this.debug("Including: %s", Arrays.deepToString(selection.getIncluded()));
        this.debug("Excluding: %s", Arrays.deepToString(selection.getExcluded()));
        return selection.getSelectedFiles();
    }

    private String[] buildExcludes() {
        ArrayList<String> ex = new ArrayList<String>();
        ex.addAll(Arrays.asList(this.excludes));
        if (this.project != null && this.project.getModules() != null && !this.aggregate) {
            for (String module : this.project.getModules()) {
                ex.add(String.valueOf(module) + "/**");
            }
        }
        return ex.toArray(new String[ex.size()]);
    }

    public final void info(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().info((CharSequence)String.format(format, params));
        }
    }

    public final void debug(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().debug((CharSequence)String.format(format, params));
        }
    }

    public final void warn(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().warn((CharSequence)String.format(format, params));
        }
    }

    private Map<String, String> buildMapping() {
        LinkedHashMap<String, String> extensionMapping = new LinkedHashMap<String, String>();
        extensionMapping.put(DocumentType.UNKNOWN.getExtension(), DocumentType.UNKNOWN.getDefaultHeaderTypeName());
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            extensionMapping.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
        }
        if (this.useDefaultMapping) {
            for (Map.Entry<String, String> entry : DocumentType.defaultMapping().entrySet()) {
                if (extensionMapping.containsKey(entry.getKey())) continue;
                extensionMapping.put(entry.getKey(), entry.getValue());
            }
        }
        return extensionMapping;
    }

    private Map<String, HeaderDefinition> buildHeaderDefinitions() throws MojoFailureException {
        HashMap<String, HeaderDefinition> headers = new HashMap<String, HeaderDefinition>(HeaderType.defaultDefinitions());
        String[] stringArray = this.headerDefinitions;
        int n = this.headerDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            String resource = stringArray[n2];
            try {
                InputSource source = new InputSource(this.finder.findResource(resource).openStream());
                source.setEncoding(this.encoding);
                AdditionalHeaderDefinition fileDefinitions = new AdditionalHeaderDefinition(XMLDoc.from((InputSource)source, (boolean)true));
                Map<String, HeaderDefinition> map = fileDefinitions.getDefinitions();
                this.debug("%d header definitions loaded from '%s'", map.size(), resource);
                headers.putAll(map);
            }
            catch (IOException ex) {
                throw new MojoFailureException("Error reading header definition: " + resource, (Throwable)ex);
            }
            ++n2;
        }
        headers.put(HeaderType.UNKNOWN.getDefinition().getType(), HeaderType.UNKNOWN.getDefinition());
        return headers;
    }

    List<Server> getDecryptedServers() {
        DefaultSettingsDecryptionRequest settingsDecryptionRequest = new DefaultSettingsDecryptionRequest();
        settingsDecryptionRequest.setServers(this.settings.getServers());
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)settingsDecryptionRequest);
        return decrypt.getServers();
    }

    public Credentials findCredentials(String serverID) {
        List<Server> decryptedServers = this.getDecryptedServers();
        for (Server ds : decryptedServers) {
            if (!ds.getId().equals(serverID)) continue;
            this.getLog().debug((CharSequence)("credentials have been found for server: " + serverID + ", login:" + ds.getUsername() + ", password:" + AbstractLicenseMojo.starEncrypt(ds.getPassword())));
            return new Credentials(ds.getUsername(), ds.getPassword());
        }
        this.getLog().debug((CharSequence)("no credentials found for server: " + serverID));
        return null;
    }

    static String starEncrypt(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(".", "*");
    }

    protected abstract class AbstractCallback
    implements Callback {
        private final Collection<File> unknownFiles = new ConcurrentLinkedQueue<File>();

        protected AbstractCallback() {
        }

        @Override
        public void onUnknownFile(Document document, Header header) {
            AbstractLicenseMojo.this.warn("Unknown file extension: %s", document.getFilePath());
            this.unknownFiles.add(document.getFile());
        }

        public void checkUnknown() throws MojoExecutionException {
            if (!this.unknownFiles.isEmpty()) {
                String msg = "Unable to find a comment style definition for some files. You may want to add a custom mapping for the relevant file extensions.";
                if (AbstractLicenseMojo.this.failIfUnknown) {
                    throw new MojoExecutionException(msg);
                }
                AbstractLicenseMojo.this.getLog().warn((CharSequence)msg);
            }
        }
    }
}

