/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.document;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

class PropertyPlaceholderResolver {
    private final String placeholderPrefix = "${";
    private final String placeholderSuffix = "}";

    PropertyPlaceholderResolver() {
    }

    public String replacePlaceholders(String value, Properties properties) {
        return this.replacePlaceholders(value, properties::getProperty);
    }

    private String replacePlaceholders(String value, Function<String, String> placeholderResolver) {
        return this.parseStringValue(value, placeholderResolver, new HashSet<String>());
    }

    private String parseStringValue(String value, Function<String, String> placeholderResolver, Set<String> visitedPlaceholders) {
        StringBuilder result = new StringBuilder(value);
        int startIndex = value.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder = result.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                placeholder = this.parseStringValue(placeholder, placeholderResolver, visitedPlaceholders);
                String propVal = placeholderResolver.apply(placeholder);
                String valueSeparator = ":";
                if (propVal == null && (separatorIndex = placeholder.indexOf(valueSeparator)) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + valueSeparator.length());
                    propVal = placeholderResolver.apply(actualPlaceholder);
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                }
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, placeholderResolver, visitedPlaceholders);
                    result.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            String simplePrefix = "{";
            if (PropertyPlaceholderResolver.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (PropertyPlaceholderResolver.substringMatch(buf, index, simplePrefix)) {
                ++withinNestedPlaceholder;
                index += simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    private static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

