/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.Callback;
import com.mycila.maven.plugin.license.Credentials;
import com.mycila.maven.plugin.license.HeaderSection;
import com.mycila.maven.plugin.license.HeaderStyle;
import com.mycila.maven.plugin.license.LicenseSet;
import com.mycila.maven.plugin.license.Multi;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.Report;
import com.mycila.maven.plugin.license.dependencies.LicensePolicy;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.document.DocumentFactory;
import com.mycila.maven.plugin.license.document.DocumentPropertiesLoader;
import com.mycila.maven.plugin.license.document.DocumentType;
import com.mycila.maven.plugin.license.header.AdditionalHeaderDefinition;
import com.mycila.maven.plugin.license.header.Header;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.header.HeaderSource;
import com.mycila.maven.plugin.license.header.HeaderType;
import com.mycila.maven.plugin.license.util.FileUtils;
import com.mycila.maven.plugin.license.util.Selection;
import com.mycila.maven.plugin.license.util.resource.ResourceFinder;
import com.mycila.xmltool.XMLDoc;
import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.xml.sax.InputSource;

public abstract class AbstractLicenseMojo
extends AbstractMojo {
    private static final String[] DEFAULT_KEYWORDS = new String[]{"copyright"};
    @Parameter
    public LicenseSet[] licenseSets;
    @Parameter(property="license.basedir", defaultValue="${project.basedir}", alias="basedir", required=true)
    public File defaultBasedir;
    @Deprecated
    @Parameter(property="license.header", alias="header")
    public String legacyConfigHeader;
    @Deprecated
    @Parameter(property="license.inlineHeader", alias="inlineHeader")
    public String legacyConfigInlineHeader;
    @Deprecated
    @Parameter(alias="validHeaders")
    public String[] legacyConfigValidHeaders = new String[0];
    @Deprecated
    @Parameter
    public Multi legacyConfigMulti;
    @Parameter(alias="headerDefinitions")
    public String[] defaultHeaderDefinitions = new String[0];
    @Parameter
    public HeaderStyle[] defaultInlineHeaderStyles = new HeaderStyle[0];
    @Deprecated
    @Parameter(alias="headerSections")
    public HeaderSection[] legacyConfigHeaderSections = new HeaderSection[0];
    @Parameter(alias="properties")
    public Map<String, String> defaultProperties = new HashMap<String, String>();
    @Deprecated
    @Parameter(alias="includes", property="license.includes")
    public String[] legacyConfigIncludes = new String[0];
    @Deprecated
    @Parameter(alias="excludes", property="license.excludes")
    public String[] legacyConfigExcludes = new String[0];
    @Deprecated
    @Parameter(alias="keywords")
    public String[] legacyConfigKeywords = DEFAULT_KEYWORDS;
    @Parameter(property="license.useDefaultExcludes", defaultValue="true", alias="useDefaultExcludes")
    public boolean defaultUseDefaultExcludes = true;
    @Parameter(property="license.aggregate", defaultValue="false")
    public boolean aggregate = false;
    @Parameter
    public Map<String, String> mapping = new LinkedHashMap<String, String>();
    @Parameter(property="license.useDefaultMapping", defaultValue="true")
    public boolean useDefaultMapping = true;
    @Parameter(property="license.concurrencyFactor", defaultValue="1.5")
    public float concurrencyFactor = 1.5f;
    @Parameter(property="license.nThreads", defaultValue="0")
    public int nThreads;
    @Parameter(property="license.skip", defaultValue="false")
    public boolean skip = false;
    @Parameter(property="license.warnIfShallow", defaultValue="true")
    public boolean warnIfShallow = true;
    @Parameter(property="license.quiet", defaultValue="false")
    public boolean quiet = false;
    @Parameter(property="license.strictCheck", defaultValue="true")
    public boolean strictCheck = true;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    public String encoding = "UTF-8";
    @Parameter(property="license.failIfMissing", defaultValue="true")
    public boolean failIfMissing = true;
    @Parameter(property="license.failIfUnknown", defaultValue="false")
    public boolean failIfUnknown = false;
    @Parameter(property="license.dryRun", defaultValue="false")
    public boolean dryRun = false;
    @Parameter(property="license.skipExistingHeaders", defaultValue="false")
    public boolean skipExistingHeaders = false;
    @Parameter(property="license.dependencies.scope", required=true, defaultValue="runtime")
    protected List<String> dependencyScopes;
    @Parameter(property="license.dependencies.enforce", required=true, defaultValue="false")
    protected boolean dependencyEnforce;
    @Parameter(property="license.dependencies.policies")
    protected Set<LicensePolicy> dependencyPolicies;
    @Parameter(property="license.dependencies.exceptionMessage", required=true, defaultValue="Some licenses were denied by policy:")
    protected String dependencyExceptionMessage;
    @Parameter(defaultValue="${project}", required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Component(hint="default")
    protected DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    protected ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${session}")
    public MavenSession session;
    @Parameter(property="license.report.location", defaultValue="${project.reporting.outputDirectory}/license-plugin-report.xml")
    public File reportLocation;
    @Parameter(property="license.report.format")
    public String reportFormat;
    @Parameter(property="license.report.skip", defaultValue="false")
    public boolean reportSkipped = false;
    @Parameter(property="license.prohibitLegacyUse", defaultValue="false")
    public boolean prohibitLegacyUse = false;
    protected Clock clock = Clock.systemUTC();
    protected Report report;

    protected final void execute(Callback callback) throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            LicenseSet[] allLicenseSets;
            if (this.prohibitLegacyUse && this.detectLegacyUse()) {
                throw new MojoExecutionException("Use of legacy parameters has been prohibited by configuration.");
            }
            this.defaultBasedir = this.getCanonicalFile(this.defaultBasedir, "license.basedir");
            LicenseSet legacyLicenseSet = this.convertLegacyConfigToLicenseSet();
            if (legacyLicenseSet != null) {
                if (this.licenseSets == null) {
                    allLicenseSets = new LicenseSet[]{legacyLicenseSet};
                } else {
                    allLicenseSets = Arrays.copyOf(this.licenseSets, this.licenseSets.length + 1);
                    allLicenseSets[this.licenseSets.length] = legacyLicenseSet;
                }
            } else {
                allLicenseSets = this.licenseSets;
            }
            this.executeForLicenseSets(allLicenseSets, callback);
            this.report.exportTo(this.reportLocation);
        }
    }

    private File getCanonicalFile(File file, String description) throws MojoFailureException {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not get canonical path of " + description, (Throwable)e);
        }
    }

    private void executeForLicenseSets(LicenseSet[] licenseSets, Callback callback) throws MojoFailureException, MojoExecutionException {
        if (licenseSets == null || licenseSets.length == 0) {
            this.warn("At least one licenseSet must be specified", new Object[0]);
            return;
        }
        for (int i = 0; i < licenseSets.length; ++i) {
            LicenseSet licenseSet = licenseSets[i];
            if (!this.hasHeader(licenseSet)) {
                this.warn("No header file specified to check for license in licenseSet: " + i, new Object[0]);
                return;
            }
            licenseSet.basedir = this.getCanonicalFile(licenseSet.basedir, "licenseSet[" + i + "].basedir");
        }
        if (!this.strictCheck) {
            this.warn("Property 'strictCheck' is not enabled. Please consider adding <strictCheck>true</strictCheck> in your pom.xml file.", new Object[0]);
            this.warn("See https://mycila.carbou.me/license-maven-plugin for more information.", new Object[0]);
        }
        for (LicenseSet licenseSet : licenseSets) {
            this.executeForLicenseSet(licenseSet, callback);
        }
    }

    private boolean detectLegacyUse() {
        return this.legacyConfigHeader != null || this.legacyConfigInlineHeader != null || this.legacyConfigValidHeaders != null && this.legacyConfigValidHeaders.length > 0 || this.legacyConfigMulti != null || this.legacyConfigHeaderSections != null && this.legacyConfigHeaderSections.length > 0 || this.legacyConfigIncludes != null && this.legacyConfigIncludes.length > 0 || this.legacyConfigExcludes != null && this.legacyConfigExcludes.length > 0 || this.legacyConfigKeywords != null && !Arrays.equals(this.legacyConfigKeywords, DEFAULT_KEYWORDS);
    }

    private LicenseSet convertLegacyConfigToLicenseSet() {
        if (this.legacyConfigHeader == null && (this.legacyConfigInlineHeader == null || this.legacyConfigInlineHeader.isEmpty())) {
            return null;
        }
        LicenseSet legacyLicenseSet = new LicenseSet();
        legacyLicenseSet.header = this.legacyConfigHeader;
        legacyLicenseSet.inlineHeader = this.legacyConfigInlineHeader;
        legacyLicenseSet.validHeaders = this.legacyConfigValidHeaders;
        legacyLicenseSet.multi = this.legacyConfigMulti;
        legacyLicenseSet.headerSections = this.legacyConfigHeaderSections;
        legacyLicenseSet.includes = this.legacyConfigIncludes;
        legacyLicenseSet.excludes = this.legacyConfigExcludes;
        legacyLicenseSet.keywords = this.legacyConfigKeywords;
        return legacyLicenseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeForLicenseSet(LicenseSet licenseSet, Callback callback) throws MojoExecutionException, MojoFailureException {
        ResourceFinder finder = new ResourceFinder(AbstractLicenseMojo.firstNonNull(FileUtils.asPath(licenseSet.basedir), FileUtils.asPath(this.defaultBasedir)));
        try {
            finder.setCompileClassPath(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finder.setPluginClassPath(((Object)((Object)this)).getClass().getClassLoader());
        HeaderSource headerSource = HeaderSource.of(licenseSet.multi, licenseSet.inlineHeader, licenseSet.header, this.encoding, finder);
        Header h = new Header(headerSource, licenseSet.headerSections);
        this.debug("Header: %s", h.getLocation());
        if (licenseSet.validHeaders == null) {
            licenseSet.validHeaders = new String[0];
        }
        ArrayList<Header> validHeaders = new ArrayList<Header>(licenseSet.validHeaders.length);
        for (String validHeader : licenseSet.validHeaders) {
            HeaderSource validHeaderSource = HeaderSource.of(null, null, validHeader, this.encoding, finder);
            validHeaders.add(new Header(validHeaderSource, licenseSet.headerSections));
        }
        final Map<String, String> globalProperties = this.getDefaultProperties();
        if (licenseSet.properties != null) {
            for (Map.Entry<String, String> entry : licenseSet.properties.entrySet()) {
                if (System.getProperties().contains(entry.getKey())) continue;
                globalProperties.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("global properties:\n - " + globalProperties.entrySet().stream().map(Objects::toString).collect(Collectors.joining("\n - "))));
        }
        final LinkedList<PropertiesProvider> propertiesProviders = new LinkedList<PropertiesProvider>();
        int threads = this.getNumberOfExecutorThreads();
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        try {
            for (PropertiesProvider provider : ServiceLoader.load(PropertiesProvider.class, Thread.currentThread().getContextClassLoader())) {
                provider.init(this, globalProperties);
                propertiesProviders.add(provider);
            }
            DocumentPropertiesLoader perDocumentProperties = new DocumentPropertiesLoader(){

                @Override
                public Map<String, String> load(Document document) {
                    LinkedHashMap<String, String> perDoc = new LinkedHashMap<String, String>(globalProperties);
                    perDoc.put("file.name", document.getFile().getName());
                    Map<String, String> readOnly = Collections.unmodifiableMap(perDoc);
                    for (PropertiesProvider provider : propertiesProviders) {
                        try {
                            Map<String, String> adjustments = provider.adjustProperties(AbstractLicenseMojo.this, readOnly, document);
                            if (AbstractLicenseMojo.this.getLog().isDebugEnabled()) {
                                AbstractLicenseMojo.this.getLog().debug((CharSequence)("provider: " + provider.getClass() + " adjusted these properties:\n" + adjustments));
                            }
                            for (Map.Entry<String, String> entry : adjustments.entrySet()) {
                                if (entry.getValue() != null) {
                                    perDoc.put(entry.getKey(), entry.getValue());
                                    continue;
                                }
                                perDoc.remove(entry.getKey());
                            }
                        }
                        catch (Exception e) {
                            AbstractLicenseMojo.this.getLog().warn((CharSequence)("failure occurred while calling " + provider.getClass()), (Throwable)e);
                        }
                    }
                    if (AbstractLicenseMojo.this.getLog().isDebugEnabled()) {
                        AbstractLicenseMojo.this.getLog().debug((CharSequence)("properties for " + document + ":\n - " + perDoc.entrySet().stream().map(Objects::toString).collect(Collectors.joining("\n - "))));
                    }
                    return perDoc;
                }
            };
            DocumentFactory documentFactory = new DocumentFactory(AbstractLicenseMojo.firstNonNull(licenseSet.basedir, this.defaultBasedir), this.buildMapping(), this.buildHeaderDefinitions(licenseSet, finder), this.encoding, licenseSet.keywords, perDocumentProperties);
            ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
            int count = 0;
            this.debug("Number of execution threads: %s", threads);
            for (String file : this.listSelectedFiles(licenseSet)) {
                completionService.submit(() -> {
                    Document document = documentFactory.createDocuments(file);
                    this.debug("Selected file: %s [header style: %s]", document.getFilePath(), document.getHeaderDefinition());
                    if (document.isNotSupported()) {
                        callback.onUnknownFile(document, h);
                    } else if (document.is(h)) {
                        this.debug("Skipping header file: %s", document.getFilePath());
                    } else if (document.hasHeader(h, this.strictCheck)) {
                        callback.onExistingHeader(document, h);
                    } else {
                        boolean headerFound = false;
                        for (Header validHeader : validHeaders) {
                            headerFound = document.hasHeader(validHeader, this.strictCheck);
                            if (!headerFound) continue;
                            callback.onExistingHeader(document, h);
                            break;
                        }
                        if (!headerFound) {
                            callback.onHeaderNotFound(document, h);
                        }
                    }
                }, null);
                ++count;
            }
            while (count-- > 0) {
                try {
                    completionService.take().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (cause instanceof MojoExecutionException) {
                        throw (MojoExecutionException)cause;
                    }
                    if (cause instanceof MojoFailureException) {
                        throw (MojoFailureException)cause;
                    }
                    if (!(cause instanceof RuntimeException)) throw new RuntimeException(cause.getMessage(), cause);
                    throw (RuntimeException)cause;
                    return;
                }
            }
        }
        finally {
            executorService.shutdownNow();
            propertiesProviders.forEach(PropertiesProvider::close);
        }
    }

    private boolean hasHeader(LicenseSet licenseSet) {
        return licenseSet.multi != null && (licenseSet.multi.headers != null && licenseSet.multi.headers.length > 0 || licenseSet.multi.inlineHeaders != null && licenseSet.multi.inlineHeaders.length > 0 && !licenseSet.multi.inlineHeaders[0].isEmpty()) || licenseSet.header != null || licenseSet.inlineHeader != null && !licenseSet.inlineHeader.isEmpty();
    }

    private int getNumberOfExecutorThreads() {
        return this.nThreads > 0 ? this.nThreads : Math.max(1, (int)((float)Runtime.getRuntime().availableProcessors() * this.concurrencyFactor));
    }

    private Map<String, String> getDefaultProperties() {
        TreeMap<String, String> props = new TreeMap<String, String>(System.getenv());
        props.put("project.groupId", this.project.getGroupId());
        props.put("project.artifactId", this.project.getArtifactId());
        props.put("project.version", this.project.getVersion());
        props.put("project.name", this.project.getName());
        props.put("project.description", this.project.getDescription());
        props.put("project.inceptionYear", this.project.getInceptionYear());
        props.put("year", this.project.getInceptionYear());
        props.put("project.url", this.project.getUrl());
        Organization org = this.project.getOrganization();
        if (org != null) {
            props.put("owner", org.getName());
            props.put("project.organization.name", org.getName());
            props.put("project.organization.url", org.getUrl());
        }
        if (this.defaultProperties != null) {
            props.putAll(this.defaultProperties);
        }
        for (String key : System.getProperties().stringPropertyNames()) {
            props.put(key, System.getProperty(key));
        }
        return props;
    }

    private String[] listSelectedFiles(LicenseSet licenseSet) {
        boolean useDefaultExcludes = licenseSet.useDefaultExcludes != null ? licenseSet.useDefaultExcludes : this.defaultUseDefaultExcludes;
        Selection selection = new Selection(AbstractLicenseMojo.firstNonNull(licenseSet.basedir, this.defaultBasedir), licenseSet.includes, this.buildExcludes(licenseSet), useDefaultExcludes, this.getLog());
        this.debug("From: %s", AbstractLicenseMojo.firstNonNull(licenseSet.basedir, this.defaultBasedir));
        this.debug("Including: %s", Arrays.deepToString(selection.getIncluded()));
        this.debug("Excluding: %s", Arrays.deepToString(selection.getExcluded()));
        return selection.getSelectedFiles();
    }

    private String[] buildExcludes(LicenseSet licenseSet) {
        ArrayList<String> ex = new ArrayList<String>();
        ex.addAll(Arrays.asList(licenseSet.excludes));
        if (this.project != null && this.project.getModules() != null && !this.aggregate) {
            for (String module : this.project.getModules()) {
                ex.add(module + "/**");
            }
        }
        return ex.toArray(new String[ex.size()]);
    }

    public final void info(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().info((CharSequence)String.format(format, params));
        }
    }

    public final void debug(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().debug((CharSequence)String.format(format, params));
        }
    }

    public final void warn(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().warn((CharSequence)String.format(format, params));
        }
    }

    private Map<String, String> buildMapping() {
        LinkedHashMap<String, String> extensionMapping = new LinkedHashMap<String, String>();
        extensionMapping.put(DocumentType.UNKNOWN.getExtension(), DocumentType.UNKNOWN.getDefaultHeaderTypeName());
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            extensionMapping.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
        }
        if (this.useDefaultMapping) {
            for (Map.Entry<String, String> entry : DocumentType.defaultMapping().entrySet()) {
                if (extensionMapping.containsKey(entry.getKey())) continue;
                extensionMapping.put(entry.getKey(), entry.getValue());
            }
        }
        return extensionMapping;
    }

    private Map<String, HeaderDefinition> buildHeaderDefinitions(LicenseSet licenseSet, ResourceFinder finder) throws MojoFailureException {
        HashMap<String, HeaderDefinition> headers = new HashMap<String, HeaderDefinition>(HeaderType.defaultDefinitions());
        for (String string : this.defaultHeaderDefinitions) {
            headers.putAll(this.loadHeaderDefinition(string, finder));
        }
        for (HeaderStyle headerStyle : this.defaultInlineHeaderStyles) {
            headers.put(headerStyle.name, headerStyle.toHeaderDefinition());
        }
        for (String string : licenseSet.headerDefinitions) {
            headers.putAll(this.loadHeaderDefinition(string, finder));
        }
        for (HeaderStyle headerStyle : licenseSet.inlineHeaderStyles) {
            headers.put(headerStyle.name, headerStyle.toHeaderDefinition());
        }
        headers.put(HeaderType.UNKNOWN.getDefinition().getType(), HeaderType.UNKNOWN.getDefinition());
        return headers;
    }

    private Map<String, HeaderDefinition> loadHeaderDefinition(String headerDefinition, ResourceFinder finder) throws MojoFailureException {
        try {
            InputSource source = new InputSource(finder.findResource(headerDefinition).openStream());
            source.setEncoding(this.encoding);
            AdditionalHeaderDefinition fileDefinitions = new AdditionalHeaderDefinition(XMLDoc.from((InputSource)source, (boolean)true));
            Map<String, HeaderDefinition> map = fileDefinitions.getDefinitions();
            this.debug("%d header definitions loaded from '%s'", map.size(), headerDefinition);
            return map;
        }
        catch (IOException ex) {
            throw new MojoFailureException("Error reading header definition: " + headerDefinition, (Throwable)ex);
        }
    }

    List<Server> getDecryptedServers() {
        DefaultSettingsDecryptionRequest settingsDecryptionRequest = new DefaultSettingsDecryptionRequest();
        settingsDecryptionRequest.setServers(this.settings.getServers());
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)settingsDecryptionRequest);
        return decrypt.getServers();
    }

    public Credentials findCredentials(String serverID) {
        if (serverID == null) {
            return null;
        }
        List<Server> decryptedServers = this.getDecryptedServers();
        for (Server ds : decryptedServers) {
            if (!ds.getId().equals(serverID)) continue;
            this.getLog().debug((CharSequence)("credentials have been found for server: " + serverID + ", login:" + ds.getUsername() + ", password:" + AbstractLicenseMojo.starEncrypt(ds.getPassword())));
            return new Credentials(ds.getUsername(), ds.getPassword());
        }
        this.getLog().debug((CharSequence)("no credentials found for server: " + serverID));
        return null;
    }

    static String starEncrypt(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(".", "*");
    }

    private static <T> T firstNonNull(T t1, T t2) {
        if (t1 != null) {
            return t1;
        }
        return t2;
    }

    protected abstract class AbstractCallback
    implements Callback {
        private final Collection<File> unknownFiles = new ConcurrentLinkedQueue<File>();

        protected AbstractCallback() {
        }

        @Override
        public void onUnknownFile(Document document, Header header) {
            AbstractLicenseMojo.this.warn("Unknown file extension: %s", document.getFilePath());
            this.unknownFiles.add(document.getFile());
            AbstractLicenseMojo.this.report.add(document.getFile(), Report.Result.UNKNOWN);
        }

        public void checkUnknown() throws MojoExecutionException {
            if (!this.unknownFiles.isEmpty()) {
                String msg = "Unable to find a comment style definition for some files. You may want to add a custom mapping for the relevant file extensions.";
                if (AbstractLicenseMojo.this.failIfUnknown) {
                    throw new MojoExecutionException(msg);
                }
                AbstractLicenseMojo.this.getLog().warn((CharSequence)msg);
            }
        }
    }
}

