/**
 * Copyright (C) 2010 Mycila <mathieu.carbou@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mycila.inject;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;

/**
 * @author Mathieu Carbou (mathieu.carbou@gmail.com)
 */
public final class MycilaGuiceException extends RuntimeException {
    private MycilaGuiceException(String message, Throwable cause) {
        super(message, cause);
    }

    private MycilaGuiceException(Throwable cause) {
        super(cause.getMessage(), cause);
        setStackTrace(cause.getStackTrace());
    }

    public static MycilaGuiceException exception(String message, Throwable cause) {
        return new MycilaGuiceException(message, cause);
    }

    public static RuntimeException runtime(Throwable throwable) {
        while (throwable instanceof InvocationTargetException
                || throwable instanceof ExecutionException
                || throwable instanceof MycilaGuiceException)
            throwable = throwable instanceof InvocationTargetException ?
                    ((InvocationTargetException) throwable).getTargetException() :
                    throwable.getCause();
        if (throwable instanceof Error)
            throw (Error) throwable;
        if (throwable instanceof RuntimeException)
            return (RuntimeException) throwable;
        return new MycilaGuiceException(throwable);
    }
}
