/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject;

import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeListener;
import com.mycila.inject.injector.AnnotatedMemberHandler;
import com.mycila.inject.injector.AnnotatedMemberHandlerTypeListener;
import com.mycila.inject.injector.FieldHandler;
import com.mycila.inject.injector.FieldHandlerTypeListener;
import com.mycila.inject.injector.KeyProvider;
import com.mycila.inject.injector.MemberInjectorTypeListener;
import com.mycila.inject.injector.MethodHandler;
import com.mycila.inject.injector.MethodHandlerTypeListener;
import com.mycila.inject.internal.asm.Type;
import com.mycila.inject.internal.cglib.core.Signature;
import com.mycila.inject.scope.ConcurrentSingleton;
import com.mycila.inject.scope.ExpiringSingleton;
import com.mycila.inject.scope.RenewableSingleton;
import com.mycila.inject.scope.ResetScope;
import com.mycila.inject.scope.ResetSingleton;
import com.mycila.inject.scope.SoftSingleton;
import com.mycila.inject.scope.WeakSingleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.inject.Qualifier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class MycilaGuice {
    private final Binder binder;

    private MycilaGuice(Binder binder) {
        this.binder = binder;
    }

    public MycilaGuice bindInterceptor(Class<?> interf, String methodName, Class<?>[] params, MethodInterceptor ... interceptors) {
        try {
            return this.bindInterceptor(Matchers.subclassesOf(interf), (Matcher<? super Method>)new SignatureMatcher(interf.getMethod(methodName, params)), interceptors);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public MycilaGuice bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        for (MethodInterceptor interceptor : interceptors) {
            this.requestInjection(interceptor);
        }
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
        return this;
    }

    public Scope expiringSingleton(long expirity, TimeUnit unit) {
        return this.requestInjection(new ExpiringSingleton(expirity, unit));
    }

    public Scope renewableSingleton(long expirity, TimeUnit unit) {
        return this.requestInjection(new RenewableSingleton(expirity, unit));
    }

    public Scope weakSingleton() {
        return this.requestInjection(new WeakSingleton());
    }

    public Scope softSingleton() {
        return this.requestInjection(new SoftSingleton());
    }

    public Scope concurrentSingleton() {
        return this.requestInjection(new ConcurrentSingleton(10L, TimeUnit.SECONDS));
    }

    public Scope concurrentSingleton(long expirity, TimeUnit unit) {
        return this.requestInjection(new ConcurrentSingleton(expirity, unit));
    }

    public ResetScope resetSingleton() {
        return this.requestInjection(new ResetSingleton());
    }

    public <A extends Annotation> MycilaGuice bindAnnotationInjector(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.requestInjection(new MemberInjectorTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MycilaGuice handleMethodAfterInjection(Class<A> annotationType, Class<? extends MethodHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.requestInjection(new MethodHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MycilaGuice handleFieldAfterInjection(Class<A> annotationType, Class<? extends FieldHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.requestInjection(new FieldHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MycilaGuice handleAfterInjection(Class<A> annotationType, Class<? extends AnnotatedMemberHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.requestInjection(new AnnotatedMemberHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <T> MycilaGuice bind(Class<T> type, T instance) {
        this.binder.bind(type).toInstance(this.requestInjection(instance));
        return this;
    }

    public MycilaGuice install(Module module) {
        this.binder.install(this.requestInjection(module));
        return this;
    }

    public <T> T requestInjection(T object) {
        this.binder.requestInjection(object);
        return object;
    }

    public MethodInterceptor createDelegatingInterceptor(Class<? extends MethodInterceptor> type) {
        return this.createDelegatingInterceptor((Key<? extends MethodInterceptor>)Key.get(type));
    }

    public MethodInterceptor createDelegatingInterceptor(Key<? extends MethodInterceptor> type) {
        Provider provider = this.binder.getProvider(type);
        return new DelegatingInterceptor(provider);
    }

    public static MycilaGuice in(Binder binder) {
        return new MycilaGuice(binder);
    }

    public static boolean isBindingAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(BindingAnnotation.class) || annotationType.isAnnotationPresent(Qualifier.class);
    }

    static final class SignatureMatcher
    extends AbstractMatcher<Method> {
        private final Signature signature;

        private SignatureMatcher(Method method) {
            this.signature = new Signature(method.getName(), Type.getReturnType(method), Type.getArgumentTypes(method));
        }

        public boolean matches(Method method) {
            return this.signature.equals(new Signature(method.getName(), Type.getReturnType(method), Type.getArgumentTypes(method)));
        }
    }

    private static final class DelegatingInterceptor
    implements MethodInterceptor {
        private final Provider<? extends MethodInterceptor> provider;

        private DelegatingInterceptor(Provider<? extends MethodInterceptor> provider) {
            this.provider = provider;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return ((MethodInterceptor)this.provider.get()).invoke(invocation);
        }

        public String toString() {
            return ((MethodInterceptor)this.provider.get()).toString();
        }
    }
}

