/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.injector;

import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.inject.injector.MethodHandler;
import com.mycila.inject.internal.Reflect;
import com.mycila.inject.internal.guava.collect.Iterables;
import com.mycila.inject.internal.guava.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class MethodHandlerTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends MethodHandler<A>> handlerClass;

    public MethodHandlerTypeListener(Class<A> annotationType, Class<? extends MethodHandler<A>> handlerClass) {
        this.annotationType = annotationType;
        this.handlerClass = handlerClass;
    }

    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Provider provider = encounter.getProvider(this.handlerClass);
        encounter.register(new InjectionListener<I>(){

            public void afterInjection(I injectee) {
                MethodHandler handler = (MethodHandler)provider.get();
                for (Method method : Lists.reverse(Lists.newLinkedList(Iterables.filter(Reflect.findMethods(type.getRawType()), Reflect.annotatedBy(MethodHandlerTypeListener.this.annotationType))))) {
                    handler.handle(type, injectee, method, method.getAnnotation(MethodHandlerTypeListener.this.annotationType));
                }
            }
        });
    }
}

