/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.mycila.inject.MycilaGuice;
import com.mycila.inject.internal.Signature;
import com.mycila.inject.internal.WeakCache;
import com.mycila.inject.internal.guava.base.Function;
import com.mycila.inject.internal.guava.base.Predicate;
import com.mycila.inject.internal.guava.collect.Iterables;
import com.mycila.inject.internal.guava.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class Reflect {
    private static final Predicate<Method> METHOD_FILTER = new Predicate<Method>(){

        @Override
        public boolean apply(Method member) {
            return !member.isSynthetic() && !member.isBridge();
        }
    };
    private static final Function<Signature, Method> TO_METHOD = new Function<Signature, Method>(){

        @Override
        public Method apply(Signature from) {
            return from.method;
        }
    };
    private static final Function<Method, Signature> TO_SIGNATURE = new Function<Method, Signature>(){

        @Override
        public Signature apply(Method from) {
            return new Signature(from);
        }
    };
    private static final List<Signature> OBJECT_METHODS = Lists.newLinkedList(Iterables.transform(Arrays.asList(Object.class.getDeclaredMethods()), TO_SIGNATURE));
    private static final WeakCache<Class<?>, Iterable<Signature>> METHOD_CACHE = new WeakCache(new WeakCache.Provider<Class<?>, Iterable<Signature>>(){

        @Override
        public Iterable<Signature> get(Class<?> clazz) {
            if (clazz == null) {
                return Collections.emptyList();
            }
            if (clazz == Object.class) {
                return OBJECT_METHODS;
            }
            final ArrayList thisMethods = Lists.newArrayList(Iterables.transform(Iterables.filter(Arrays.asList(clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods()), METHOD_FILTER), TO_SIGNATURE));
            return Iterables.concat(thisMethods, Iterables.filter((Iterable)METHOD_CACHE.get(clazz.getSuperclass()), new Predicate<Signature>(){

                @Override
                public boolean apply(Signature input) {
                    int pos = thisMethods.indexOf(input);
                    if (pos == -1) {
                        return true;
                    }
                    Signature override = (Signature)thisMethods.get(pos);
                    return !Reflect.overrides(override.method, input.method);
                }
            }));
        }
    });

    public static List<Key<?>> getParameterKeys(TypeLiteral<?> injectedType, Method injectedMember) {
        Annotation[][] parameterAnnotations = injectedMember.getParameterAnnotations();
        List parameterTypes = injectedType.getParameterTypes((Member)injectedMember);
        ArrayList keys = new ArrayList();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            keys.add(Reflect.buildKey((TypeLiteral)parameterTypes.get(i), parameterAnnotations[i]));
        }
        return keys;
    }

    public static Key<?> buildKey(TypeLiteral<?> type, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!MycilaGuice.isBindingAnnotation(annotation.annotationType())) continue;
            return Key.get(type, (Annotation)annotation);
        }
        return Key.get(type);
    }

    public static Class<?> getTargetClass(Class<?> proxy) {
        if (proxy.getName().contains("$$")) {
            while ((proxy = proxy.getSuperclass()).getName().contains("$$")) {
            }
            return proxy;
        }
        return proxy;
    }

    public static Class<?> getTargetClass(Object instance) {
        return Reflect.getTargetClass(instance.getClass());
    }

    public static <T> Predicate<T> predicate(final Matcher<T> matcher) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return matcher.matches(input);
            }
        };
    }

    public static <T> Matcher<T> matcher(final Predicate<T> predicate) {
        return new AbstractMatcher<T>(){

            public boolean matches(T t) {
                return predicate.apply(t);
            }
        };
    }

    public static Predicate<Method> withParameterTypes(final Class<?> ... classes) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(Method m) {
                Class<?>[] thisParams = m.getParameterTypes();
                if (thisParams.length != classes.length) {
                    return false;
                }
                int c = 0;
                for (Class<?> thisParam : thisParams) {
                    if (thisParam == classes[c++]) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T extends Member> Predicate<T> named(final String methodName) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T member) {
                return member.getName().equals(methodName);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> annotatedBy(final Class<? extends Annotation> annotationType) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T element) {
                return element.isAnnotationPresent(annotationType);
            }
        };
    }

    public static Iterable<Method> findMethods(Class<?> clazz) {
        return Iterables.transform(METHOD_CACHE.get(clazz), TO_METHOD);
    }

    public static Iterable<Field> findFields(Class<?> type, Predicate<? super Field> predicate) {
        LinkedList<Field> fields = new LinkedList<Field>();
        while (type != null && type != Object.class) {
            for (Field field : type.getDeclaredFields()) {
                if (!predicate.apply(field)) continue;
                fields.add(field);
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    private Reflect() {
    }

    private static boolean overrides(Method a, Method b) {
        int modifiers = b.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }
}

