/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.collect;

import com.mycila.inject.internal.guava.annotations.Beta;
import com.mycila.inject.internal.guava.annotations.GwtCompatible;
import com.mycila.inject.internal.guava.base.Preconditions;
import com.mycila.inject.internal.guava.collect.BoundType;
import com.mycila.inject.internal.guava.collect.DiscreteDomain;
import com.mycila.inject.internal.guava.collect.ImmutableSortedSet;
import com.mycila.inject.internal.guava.collect.Ordering;
import com.mycila.inject.internal.guava.collect.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public abstract class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    final DiscreteDomain<C> domain;

    ContiguousSet(DiscreteDomain<C> domain) {
        super(Ordering.natural());
        this.domain = domain;
    }

    @Override
    public ContiguousSet<C> headSet(C toElement) {
        return this.headSet((C)((Comparable)Preconditions.checkNotNull(toElement)), false);
    }

    @Override
    ContiguousSet<C> headSet(C toElement, boolean inclusive) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(toElement)), inclusive);
    }

    @Override
    public ContiguousSet<C> subSet(C fromElement, C toElement) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    ContiguousSet<C> subSet(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public ContiguousSet<C> tailSet(C fromElement) {
        return this.tailSet((C)((Comparable)Preconditions.checkNotNull(fromElement)), true);
    }

    @Override
    ContiguousSet<C> tailSet(C fromElement, boolean inclusive) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(fromElement)), inclusive);
    }

    @Override
    abstract ContiguousSet<C> headSetImpl(C var1, boolean var2);

    @Override
    abstract ContiguousSet<C> subSetImpl(C var1, boolean var2, C var3, boolean var4);

    @Override
    abstract ContiguousSet<C> tailSetImpl(C var1, boolean var2);

    public abstract ContiguousSet<C> intersection(ContiguousSet<C> var1);

    public abstract Range<C> range();

    public abstract Range<C> range(BoundType var1, BoundType var2);

    @Override
    public String toString() {
        return this.range().toString();
    }
}

