/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.io;

import com.mycila.inject.internal.guava.annotations.Beta;
import com.mycila.inject.internal.guava.base.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@Beta
public final class LimitInputStream
extends FilterInputStream {
    private long left;
    private long mark = -1L;

    public LimitInputStream(InputStream in, long limit) {
        super(in);
        Preconditions.checkNotNull(in);
        Preconditions.checkArgument(limit >= 0L, "limit must be non-negative");
        this.left = limit;
    }

    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.left;
    }

    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read(b, off, len = (int)Math.min((long)len, this.left));
        if (result != -1) {
            this.left -= (long)result;
        }
        return result;
    }

    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    public long skip(long n) throws IOException {
        n = Math.min(n, this.left);
        long skipped = this.in.skip(n);
        this.left -= skipped;
        return skipped;
    }
}

