/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.redis;

import com.mycila.inject.redis.RedisCallback;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public final class Redis {
    private static final Logger LOGGER = Logger.getLogger(Redis.class.getName());
    private static final ThreadLocal<Jedis> connection = new ThreadLocal();
    private static JedisPool pool;

    private Redis() {
    }

    public static Jedis get() {
        Jedis jedis = connection.get();
        if (jedis == null) {
            throw new IllegalStateException("No Redis connection bound to local thread");
        }
        return jedis;
    }

    static boolean isEmpty() {
        return connection.get() == null;
    }

    static void set(Jedis jedis) {
        if (connection.get() != null) {
            throw new IllegalStateException("Redis connection already bound to local thread");
        }
        connection.set(jedis);
    }

    static Jedis remove() {
        Jedis jedis = Redis.get();
        connection.remove();
        return jedis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, E extends Throwable> V execute(RedisCallback<V, E> cb) throws E {
        if (pool == null) {
            throw new IllegalStateException("No JedisPool injected");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting Redis connection from pool...");
        }
        Jedis jedis = (Jedis)pool.getResource();
        try {
            V v = cb.execute(jedis);
            return v;
        }
        finally {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Returning Redis connection to pool...");
            }
            pool.returnResource((Object)jedis);
        }
    }

    @Inject
    static void setPool(JedisPool pool) {
        if (Redis.pool != null) {
            LOGGER.log(Level.WARNING, "JedisPool pool already set");
        }
        Redis.pool = pool;
    }
}

