/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.scope;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.mycila.inject.MycilaGuiceException;
import com.mycila.inject.annotation.Jsr250Singleton;
import com.mycila.inject.scope.MycilaScope;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;

@Jsr250Singleton
public final class ConcurrentSingleton
extends MycilaScope {
    final long expirationDelay;
    private final FutureInjector futureInjector = new FutureInjector();
    private final ExecutorService executor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors() * 10, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory("@" + ConcurrentSingleton.class.getSimpleName() + "-Thread-"), new ThreadPoolExecutor.DiscardOldestPolicy());

    public ConcurrentSingleton(long expirationDelay, TimeUnit unit) {
        this.expirationDelay = unit.toMillis(expirationDelay);
    }

    @Inject
    public void initFuture(Injector injector) {
        this.futureInjector.setInjector(injector);
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdown();
    }

    public <T> Provider<T> scope(final Key<T> key, Provider<T> unscoped) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    long expirationTime = System.currentTimeMillis() + ConcurrentSingleton.this.expirationDelay;
                    while (!Thread.currentThread().isInterrupted() && System.currentTimeMillis() < expirationTime) {
                        Injector injector = ConcurrentSingleton.this.futureInjector.waitAndGet(500L, TimeUnit.MILLISECONDS).get();
                        if (injector == null) {
                            Thread.sleep(500L);
                            continue;
                        }
                        Binding binding = injector.getExistingBinding(key);
                        if (binding == null) {
                            Thread.sleep(500L);
                            continue;
                        }
                        try {
                            binding.getProvider().get();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        return new FutureProvider(key, unscoped);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicLong threadNumber = new AtomicLong();
        private final String namePrefix;

        private DefaultThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static final class FutureProvider<T>
    extends FutureTask<T>
    implements Provider<T> {
        private final Key<T> key;

        private FutureProvider(Key<T> key, final Provider<T> unscoped) {
            super(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return unscoped.get();
                }
            });
            this.key = key;
        }

        @Override
        public T get() {
            try {
                if (!this.isDone()) {
                    this.run();
                }
                return (T)super.get();
            }
            catch (ExecutionException e) {
                throw MycilaGuiceException.runtime(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw MycilaGuiceException.runtime(e);
            }
        }

        @Override
        public String toString() {
            return "FutureProvider[" + this.key + "]";
        }
    }

    private static final class FutureInjector {
        private volatile WeakReference<Injector> injector = new WeakReference<Object>(null);
        private final CountDownLatch injectorAvailable = new CountDownLatch(1);

        private FutureInjector() {
        }

        public void setInjector(Injector injector) {
            if (this.injector.get() != null) {
                return;
            }
            this.injector = new WeakReference<Injector>(injector);
            this.injectorAvailable.countDown();
        }

        public Reference<Injector> waitAndGet(long timeout, TimeUnit unit) throws InterruptedException {
            this.injectorAvailable.await(timeout, unit);
            return this.injector;
        }
    }
}

