/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.myjeeva.digitalocean.pojo.ForwardingRules;
import com.myjeeva.digitalocean.pojo.LoadBalancer;
import java.lang.reflect.Type;

public class LoadBalancerSerializer
implements JsonSerializer<LoadBalancer> {
    public JsonElement serialize(LoadBalancer loadBalancer, Type paramType, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", loadBalancer.getName());
        jsonObject.addProperty("region", loadBalancer.getRegion().getSlug());
        if (null != loadBalancer.getAlgorithm()) {
            jsonObject.addProperty("algorithm", loadBalancer.getAlgorithm().toString());
        }
        if (null != loadBalancer.getForwardingRules() && !loadBalancer.getForwardingRules().isEmpty()) {
            JsonArray rules = new JsonArray();
            for (ForwardingRules rule : loadBalancer.getForwardingRules()) {
                rules.add(context.serialize((Object)rule));
            }
            jsonObject.add("forwarding_rules", (JsonElement)rules);
        }
        if (null != loadBalancer.getHealthCheck()) {
            jsonObject.add("health_check", context.serialize((Object)loadBalancer.getHealthCheck()));
        }
        if (null != loadBalancer.getStickySessions()) {
            jsonObject.add("sticky_sessions", context.serialize((Object)loadBalancer.getStickySessions()));
        }
        if (null != loadBalancer.getDropletIds() && !loadBalancer.getDropletIds().isEmpty()) {
            JsonArray dropletIds = new JsonArray();
            for (String dropletId : loadBalancer.getDropletIds()) {
                dropletIds.add(context.serialize((Object)dropletId));
            }
            jsonObject.add("droplet_ids", (JsonElement)dropletIds);
        }
        return jsonObject;
    }
}

