/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean;

import com.myjeeva.digitalocean.common.ActionType;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.pojo.Account;
import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import com.myjeeva.digitalocean.pojo.Backups;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Domain;
import com.myjeeva.digitalocean.pojo.DomainRecord;
import com.myjeeva.digitalocean.pojo.DomainRecords;
import com.myjeeva.digitalocean.pojo.Domains;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Droplets;
import com.myjeeva.digitalocean.pojo.FloatingIP;
import com.myjeeva.digitalocean.pojo.FloatingIPs;
import com.myjeeva.digitalocean.pojo.Image;
import com.myjeeva.digitalocean.pojo.Images;
import com.myjeeva.digitalocean.pojo.Kernels;
import com.myjeeva.digitalocean.pojo.Key;
import com.myjeeva.digitalocean.pojo.Keys;
import com.myjeeva.digitalocean.pojo.Neighbors;
import com.myjeeva.digitalocean.pojo.Regions;
import com.myjeeva.digitalocean.pojo.Resource;
import com.myjeeva.digitalocean.pojo.Response;
import com.myjeeva.digitalocean.pojo.Sizes;
import com.myjeeva.digitalocean.pojo.Snapshot;
import com.myjeeva.digitalocean.pojo.Snapshots;
import com.myjeeva.digitalocean.pojo.Tag;
import com.myjeeva.digitalocean.pojo.Tags;
import com.myjeeva.digitalocean.pojo.Volume;
import com.myjeeva.digitalocean.pojo.Volumes;
import java.util.List;

public interface DigitalOcean {
    public Droplets getAvailableDroplets(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Kernels getDropletKernels(Integer var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshots getDropletSnapshots(Integer var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Backups getDropletBackups(Integer var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Droplet getDropletInfo(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Droplet createDroplet(Droplet var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Droplets createDroplets(Droplet var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteDroplet(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteDropletByTagName(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Droplets getDropletNeighbors(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Neighbors getAllDropletNeighbors(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action rebootDroplet(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action powerCycleDroplet(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action shutdownDroplet(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action powerOffDroplet(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action powerOnDroplet(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action resetDropletPassword(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action resizeDroplet(Integer var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action takeDropletSnapshot(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action takeDropletSnapshot(Integer var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action restoreDroplet(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action rebuildDroplet(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action enableDropletBackups(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action disableDropletBackups(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action renameDroplet(Integer var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action changeDropletKernel(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action enableDropletIpv6(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action enableDropletPrivateNetworking(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Account getAccountInfo() throws DigitalOceanException, RequestUnsuccessfulException;

    public Actions getAvailableActions(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action getActionInfo(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Actions getAvailableDropletActions(Integer var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Actions getAvailableImageActions(Integer var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Actions getAvailableFloatingIPActions(String var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action getFloatingIPActionInfo(String var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Images getAvailableImages(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Images getAvailableImages(Integer var1, Integer var2, ActionType var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Images getUserImages(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Image getImageInfo(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Image getImageInfo(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Image updateImage(Image var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteImage(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action transferImage(Integer var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action convertImage(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Regions getAvailableRegions(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Sizes getAvailableSizes(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Domains getAvailableDomains(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Domain getDomainInfo(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Domain createDomain(Domain var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteDomain(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public DomainRecords getDomainRecords(String var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public DomainRecord createDomainRecord(String var1, DomainRecord var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public DomainRecord getDomainRecordInfo(String var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public DomainRecord updateDomainRecord(String var1, Integer var2, DomainRecord var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteDomainRecord(String var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Keys getAvailableKeys(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Key getKeyInfo(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Key getKeyInfo(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Key createKey(Key var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Key updateKey(Integer var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Key updateKey(String var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteKey(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteKey(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public FloatingIPs getAvailableFloatingIPs(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public FloatingIP createFloatingIP(Integer var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public FloatingIP createFloatingIP(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public FloatingIP getFloatingIPInfo(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteFloatingIP(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action assignFloatingIP(Integer var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action unassignFloatingIP(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Tags getAvailableTags(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Tag createTag(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Tag getTag(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Tag updateTag(String var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteTag(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Response tagResources(String var1, List<Resource> var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Response untagResources(String var1, List<Resource> var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Volumes getAvailableVolumes(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Volume createVolume(Volume var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Volume getVolumeInfo(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Volumes getVolumeInfo(String var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteVolume(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteVolume(String var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action attachVolume(Integer var1, String var2, String var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action attachVolumeByName(Integer var1, String var2, String var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action detachVolume(Integer var1, String var2, String var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action detachVolumeByName(Integer var1, String var2, String var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action resizeVolume(String var1, String var2, Double var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Actions getAvailableVolumeActions(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Action getVolumeAction(String var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshots getVolumeSnapshots(String var1, Integer var2, Integer var3) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshot takeVolumeSnapshot(String var1, String var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshots getAvailableSnapshots(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshots getAllDropletSnapshots(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshots getAllVolumeSnapshots(Integer var1, Integer var2) throws DigitalOceanException, RequestUnsuccessfulException;

    public Snapshot getSnaphotInfo(String var1) throws DigitalOceanException, RequestUnsuccessfulException;

    public Delete deleteSnapshot(String var1) throws DigitalOceanException, RequestUnsuccessfulException;
}

