/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.common;

public enum ActionType {
    CREATE("create"),
    REBOOT("reboot"),
    POWER_CYCLE("power_cycle"),
    SHUTDOWN("shutdown"),
    POWER_OFF("power_off"),
    POWER_ON("power_on"),
    PASSWORD_RESET("password_reset"),
    RESIZE("resize"),
    RESTORE("restore"),
    REBUILD("rebuild"),
    RENAME("rename"),
    CHANGE_KERNEL("change_kernel"),
    ENABLE_IPV6("enable_ipv6"),
    ENABLE_BACKUPS("enable_backups"),
    DISABLE_BACKUPS("disable_backups"),
    ENABLE_PRIVATE_NETWORKING("enable_private_networking"),
    SNAPSHOT("snapshot"),
    BACKUP("backup"),
    TRANSFER("transfer"),
    CONVERT("convert"),
    CONVERT_TO_SNAPSHOT("convert_to_snapshot"),
    DISTRIBUTION("distribution"),
    APPLICATION("application"),
    ASSIGN_FLOATING_IP("assign_ip"),
    UNASSIGN_FLOATING_IP("unassign_ip"),
    RESERVE_FLOATING_IP("reserve_ip"),
    ATTACH("attach"),
    DETACH("detach");

    private String value;

    private ActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ActionType fromValue(String value) {
        if (null == value || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        for (ActionType dat : ActionType.values()) {
            if (!value.equalsIgnoreCase(dat.value)) continue;
            return dat;
        }
        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}

