package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * LocalEncryptionKeyRequest
 */

public class LocalEncryptionKeyRequest  implements Serializable {
  
  private String configId = null;
  private String publicKey = null;
  private String keypairId = null;

  
  /**
   * The local configuration id that contains metadata on private local service
   **/
  public LocalEncryptionKeyRequest configId(String configId) {
    this.configId = configId;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The local configuration id that contains metadata on private local service")
  @JsonProperty("configId")
  public String getConfigId() {
    return configId;
  }
  public void setConfigId(String configId) {
    this.configId = configId;
  }


  /**
   * Base 64 encoded public key, generated by the local service.
   **/
  public LocalEncryptionKeyRequest publicKey(String publicKey) {
    this.publicKey = publicKey;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Base 64 encoded public key, generated by the local service.")
  @JsonProperty("publicKey")
  public String getPublicKey() {
    return publicKey;
  }
  public void setPublicKey(String publicKey) {
    this.publicKey = publicKey;
  }


  /**
   * The key pair id from the local service.
   **/
  public LocalEncryptionKeyRequest keypairId(String keypairId) {
    this.keypairId = keypairId;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The key pair id from the local service.")
  @JsonProperty("keypairId")
  public String getKeypairId() {
    return keypairId;
  }
  public void setKeypairId(String keypairId) {
    this.keypairId = keypairId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalEncryptionKeyRequest localEncryptionKeyRequest = (LocalEncryptionKeyRequest) o;

    return Objects.equals(this.configId, localEncryptionKeyRequest.configId) &&
            Objects.equals(this.publicKey, localEncryptionKeyRequest.publicKey) &&
            Objects.equals(this.keypairId, localEncryptionKeyRequest.keypairId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configId, publicKey, keypairId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalEncryptionKeyRequest {\n");
    
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("    keypairId: ").append(toIndentedString(keypairId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

