package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import java.io.Serializable;
/**
 * A group of schedules that define the operating hours of an organization.
 */
@ApiModel(description = "A group of schedules that define the operating hours of an organization.")

public class ScheduleGroup  implements Serializable {
  
  private String id = null;
  private String name = null;
  private WritableDivision division = null;
  private String description = null;
  private Integer version = null;
  private Date dateCreated = null;
  private Date dateModified = null;
  private String modifiedBy = null;
  private String createdBy = null;

  private static class StateEnumDeserializer extends StdDeserializer<StateEnum> {
    public StateEnumDeserializer() {
      super(StateEnumDeserializer.class);
    }

    @Override
    public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt)
            throws IOException {
      JsonNode node = jsonParser.getCodec().readTree(jsonParser);
      return StateEnum.fromString(node.toString().replace("\"", ""));
    }
  }
  /**
   * Indicates if the resource is active, inactive, or deleted.
   */
 @JsonDeserialize(using = StateEnumDeserializer.class)
  public enum StateEnum {
    OUTDATEDSDKVERSION("OutdatedSdkVersion"),
    ACTIVE("active"),
    INACTIVE("inactive"),
    DELETED("deleted");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonCreator
    public static StateEnum fromString(String key) {
      if (key == null) return null;

      for (StateEnum value : StateEnum.values()) {
        if (key.equalsIgnoreCase(value.toString())) {
          return value;
        }
      }

      return StateEnum.values()[0];
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }
  private StateEnum state = null;
  private String modifiedByApp = null;
  private String createdByApp = null;
  private String timeZone = null;
  private List<DomainEntityRef> openSchedules = new ArrayList<DomainEntityRef>();
  private List<DomainEntityRef> closedSchedules = new ArrayList<DomainEntityRef>();
  private List<DomainEntityRef> holidaySchedules = new ArrayList<DomainEntityRef>();
  private String selfUri = null;

  
  @ApiModelProperty(example = "null", value = "The globally unique identifier for the object.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }


  /**
   * The name of the entity.
   **/
  public ScheduleGroup name(String name) {
    this.name = name;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The name of the entity.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }


  /**
   * The division to which this entity belongs.
   **/
  public ScheduleGroup division(WritableDivision division) {
    this.division = division;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The division to which this entity belongs.")
  @JsonProperty("division")
  public WritableDivision getDivision() {
    return division;
  }
  public void setDivision(WritableDivision division) {
    this.division = division;
  }


  /**
   * The resource's description.
   **/
  public ScheduleGroup description(String description) {
    this.description = description;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The resource's description.")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }


  /**
   * The current version of the resource.
   **/
  public ScheduleGroup version(Integer version) {
    this.version = version;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The current version of the resource.")
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }
  public void setVersion(Integer version) {
    this.version = version;
  }


  @ApiModelProperty(example = "null", value = "The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
  @JsonProperty("dateCreated")
  public Date getDateCreated() {
    return dateCreated;
  }


  @ApiModelProperty(example = "null", value = "The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
  @JsonProperty("dateModified")
  public Date getDateModified() {
    return dateModified;
  }


  @ApiModelProperty(example = "null", value = "The ID of the user that last modified the resource.")
  @JsonProperty("modifiedBy")
  public String getModifiedBy() {
    return modifiedBy;
  }


  @ApiModelProperty(example = "null", value = "The ID of the user that created the resource.")
  @JsonProperty("createdBy")
  public String getCreatedBy() {
    return createdBy;
  }


  @ApiModelProperty(example = "null", value = "Indicates if the resource is active, inactive, or deleted.")
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }


  @ApiModelProperty(example = "null", value = "The application that last modified the resource.")
  @JsonProperty("modifiedByApp")
  public String getModifiedByApp() {
    return modifiedByApp;
  }


  @ApiModelProperty(example = "null", value = "The application that created the resource.")
  @JsonProperty("createdByApp")
  public String getCreatedByApp() {
    return createdByApp;
  }


  /**
   * The timezone the schedules are a part of.  This is not a schedule property to allow a schedule to be used in multiple timezones.
   **/
  public ScheduleGroup timeZone(String timeZone) {
    this.timeZone = timeZone;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The timezone the schedules are a part of.  This is not a schedule property to allow a schedule to be used in multiple timezones.")
  @JsonProperty("timeZone")
  public String getTimeZone() {
    return timeZone;
  }
  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }


  /**
   * The schedules defining the hours an organization is open.
   **/
  public ScheduleGroup openSchedules(List<DomainEntityRef> openSchedules) {
    this.openSchedules = openSchedules;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The schedules defining the hours an organization is open.")
  @JsonProperty("openSchedules")
  public List<DomainEntityRef> getOpenSchedules() {
    return openSchedules;
  }
  public void setOpenSchedules(List<DomainEntityRef> openSchedules) {
    this.openSchedules = openSchedules;
  }


  /**
   * The schedules defining the hours an organization is closed.
   **/
  public ScheduleGroup closedSchedules(List<DomainEntityRef> closedSchedules) {
    this.closedSchedules = closedSchedules;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The schedules defining the hours an organization is closed.")
  @JsonProperty("closedSchedules")
  public List<DomainEntityRef> getClosedSchedules() {
    return closedSchedules;
  }
  public void setClosedSchedules(List<DomainEntityRef> closedSchedules) {
    this.closedSchedules = closedSchedules;
  }


  /**
   * The schedules defining the hours an organization is closed for the holidays.
   **/
  public ScheduleGroup holidaySchedules(List<DomainEntityRef> holidaySchedules) {
    this.holidaySchedules = holidaySchedules;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The schedules defining the hours an organization is closed for the holidays.")
  @JsonProperty("holidaySchedules")
  public List<DomainEntityRef> getHolidaySchedules() {
    return holidaySchedules;
  }
  public void setHolidaySchedules(List<DomainEntityRef> holidaySchedules) {
    this.holidaySchedules = holidaySchedules;
  }


  @ApiModelProperty(example = "null", value = "The URI for this object")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleGroup scheduleGroup = (ScheduleGroup) o;

    return Objects.equals(this.id, scheduleGroup.id) &&
            Objects.equals(this.name, scheduleGroup.name) &&
            Objects.equals(this.division, scheduleGroup.division) &&
            Objects.equals(this.description, scheduleGroup.description) &&
            Objects.equals(this.version, scheduleGroup.version) &&
            Objects.equals(this.dateCreated, scheduleGroup.dateCreated) &&
            Objects.equals(this.dateModified, scheduleGroup.dateModified) &&
            Objects.equals(this.modifiedBy, scheduleGroup.modifiedBy) &&
            Objects.equals(this.createdBy, scheduleGroup.createdBy) &&
            Objects.equals(this.state, scheduleGroup.state) &&
            Objects.equals(this.modifiedByApp, scheduleGroup.modifiedByApp) &&
            Objects.equals(this.createdByApp, scheduleGroup.createdByApp) &&
            Objects.equals(this.timeZone, scheduleGroup.timeZone) &&
            Objects.equals(this.openSchedules, scheduleGroup.openSchedules) &&
            Objects.equals(this.closedSchedules, scheduleGroup.closedSchedules) &&
            Objects.equals(this.holidaySchedules, scheduleGroup.holidaySchedules) &&
            Objects.equals(this.selfUri, scheduleGroup.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, division, description, version, dateCreated, dateModified, modifiedBy, createdBy, state, modifiedByApp, createdByApp, timeZone, openSchedules, closedSchedules, holidaySchedules, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleGroup {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    division: ").append(toIndentedString(division)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    dateCreated: ").append(toIndentedString(dateCreated)).append("\n");
    sb.append("    dateModified: ").append(toIndentedString(dateModified)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    modifiedByApp: ").append(toIndentedString(modifiedByApp)).append("\n");
    sb.append("    createdByApp: ").append(toIndentedString(createdByApp)).append("\n");
    sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
    sb.append("    openSchedules: ").append(toIndentedString(openSchedules)).append("\n");
    sb.append("    closedSchedules: ").append(toIndentedString(closedSchedules)).append("\n");
    sb.append("    holidaySchedules: ").append(toIndentedString(holidaySchedules)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

