/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DomainNetworkAddress
implements Serializable {
    private TypeEnum type = null;
    private String address = null;
    private Boolean persistent = null;
    private FamilyEnum family = null;

    public DomainNetworkAddress type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of address.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DomainNetworkAddress address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="An IPv4 or IPv6 IP address. When specifying an address of type \"ip\", use CIDR format for the subnet mask.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public DomainNetworkAddress persistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this address will persist on Edge restart.  Addresses assigned by DHCP will be returned as false.")
    @JsonProperty(value="persistent")
    public Boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public DomainNetworkAddress family(FamilyEnum family) {
        this.family = family;
        return this;
    }

    @ApiModelProperty(example="null", value="The address family for this address.")
    @JsonProperty(value="family")
    public FamilyEnum getFamily() {
        return this.family;
    }

    public void setFamily(FamilyEnum family) {
        this.family = family;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainNetworkAddress domainNetworkAddress = (DomainNetworkAddress)o;
        return Objects.equals((Object)this.type, (Object)domainNetworkAddress.type) && Objects.equals(this.address, domainNetworkAddress.address) && Objects.equals(this.persistent, domainNetworkAddress.persistent) && Objects.equals((Object)this.family, (Object)domainNetworkAddress.family);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.address, this.persistent, this.family});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainNetworkAddress {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    persistent: ").append(this.toIndentedString(this.persistent)).append("\n");
        sb.append("    family: ").append(this.toIndentedString((Object)this.family)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IP("ip"),
        DNS("dns"),
        GATEWAY("gateway"),
        TDM("tdm");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FamilyEnumDeserializer.class)
    public static enum FamilyEnum {
        OUTDATEDSDKVERSION(-1),
        NUMBER_2(2),
        NUMBER_23(23);

        private Integer value;

        private FamilyEnum(Integer value) {
            this.value = value;
        }

        @JsonCreator
        public static FamilyEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FamilyEnum value : FamilyEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FamilyEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FamilyEnumDeserializer
    extends StdDeserializer<FamilyEnum> {
        public FamilyEnumDeserializer() {
            super(FamilyEnumDeserializer.class);
        }

        public FamilyEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FamilyEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

