package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;

import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.model.*;
import com.mypurecloud.sdk.v2.Pair;

import com.mypurecloud.sdk.v2.model.CreateTriggerRequest;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.TestModeEventResults;
import com.mypurecloud.sdk.v2.model.TestModeResults;
import com.mypurecloud.sdk.v2.model.TopicCursorEntityListing;
import com.mypurecloud.sdk.v2.model.Trigger;
import com.mypurecloud.sdk.v2.model.TriggerEntityListing;
import com.mypurecloud.sdk.v2.model.UpdateTriggerRequest;


import com.mypurecloud.sdk.v2.api.request.DeleteProcessautomationTriggerRequest;
import com.mypurecloud.sdk.v2.api.request.GetProcessautomationTriggerRequest;
import com.mypurecloud.sdk.v2.api.request.GetProcessautomationTriggersRequest;
import com.mypurecloud.sdk.v2.api.request.GetProcessautomationTriggersTopicsRequest;
import com.mypurecloud.sdk.v2.api.request.PostProcessautomationTriggerTestRequest;
import com.mypurecloud.sdk.v2.api.request.PostProcessautomationTriggersRequest;
import com.mypurecloud.sdk.v2.api.request.PostProcessautomationTriggersTopicTestRequest;
import com.mypurecloud.sdk.v2.api.request.PutProcessautomationTriggerRequest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class ProcessAutomationApiAsync {
  private final ApiClient pcapiClient;

  public ProcessAutomationApiAsync() {
    this(Configuration.getDefaultApiClient());
  }

  public ProcessAutomationApiAsync(ApiClient apiClient) {
    this.pcapiClient = apiClient;
  }

  /**
   * Delete a Trigger
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<Void> deleteProcessautomationTriggerAsync(DeleteProcessautomationTriggerRequest request, final AsyncApiCallback<Void> callback) {
    try {
      final SettableFuture<Void> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), null, new AsyncApiCallback<ApiResponse<Void>>() {
        @Override
        public void onCompleted(ApiResponse<Void> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Delete a Trigger
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<Void>> deleteProcessautomationTriggerAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Void>> callback) {
    try {
      final SettableFuture<ApiResponse<Void>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, null, new AsyncApiCallback<ApiResponse<Void>>() {
        @Override
        public void onCompleted(ApiResponse<Void> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<Void> response = (ApiResponse<Void>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<Void> response = (ApiResponse<Void>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Retrieve a single Trigger matching id
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<Trigger> getProcessautomationTriggerAsync(GetProcessautomationTriggerRequest request, final AsyncApiCallback<Trigger> callback) {
    try {
      final SettableFuture<Trigger> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Trigger>() {}, new AsyncApiCallback<ApiResponse<Trigger>>() {
        @Override
        public void onCompleted(ApiResponse<Trigger> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Retrieve a single Trigger matching id
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<Trigger>> getProcessautomationTriggerAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Trigger>> callback) {
    try {
      final SettableFuture<ApiResponse<Trigger>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<Trigger>() {}, new AsyncApiCallback<ApiResponse<Trigger>>() {
        @Override
        public void onCompleted(ApiResponse<Trigger> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<Trigger> response = (ApiResponse<Trigger>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<Trigger> response = (ApiResponse<Trigger>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Retrieves all triggers, optionally filtered by query parameters.
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<TriggerEntityListing> getProcessautomationTriggersAsync(GetProcessautomationTriggersRequest request, final AsyncApiCallback<TriggerEntityListing> callback) {
    try {
      final SettableFuture<TriggerEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<TriggerEntityListing>() {}, new AsyncApiCallback<ApiResponse<TriggerEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<TriggerEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Retrieves all triggers, optionally filtered by query parameters.
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<TriggerEntityListing>> getProcessautomationTriggersAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<TriggerEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<TriggerEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<TriggerEntityListing>() {}, new AsyncApiCallback<ApiResponse<TriggerEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<TriggerEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<TriggerEntityListing> response = (ApiResponse<TriggerEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<TriggerEntityListing> response = (ApiResponse<TriggerEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Get topics available for organization
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<TopicCursorEntityListing> getProcessautomationTriggersTopicsAsync(GetProcessautomationTriggersTopicsRequest request, final AsyncApiCallback<TopicCursorEntityListing> callback) {
    try {
      final SettableFuture<TopicCursorEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<TopicCursorEntityListing>() {}, new AsyncApiCallback<ApiResponse<TopicCursorEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<TopicCursorEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Get topics available for organization
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<TopicCursorEntityListing>> getProcessautomationTriggersTopicsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<TopicCursorEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<TopicCursorEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<TopicCursorEntityListing>() {}, new AsyncApiCallback<ApiResponse<TopicCursorEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<TopicCursorEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<TopicCursorEntityListing> response = (ApiResponse<TopicCursorEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<TopicCursorEntityListing> response = (ApiResponse<TopicCursorEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Test the matching of a Trigger based on provided event body
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<TestModeResults> postProcessautomationTriggerTestAsync(PostProcessautomationTriggerTestRequest request, final AsyncApiCallback<TestModeResults> callback) {
    try {
      final SettableFuture<TestModeResults> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<TestModeResults>() {}, new AsyncApiCallback<ApiResponse<TestModeResults>>() {
        @Override
        public void onCompleted(ApiResponse<TestModeResults> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Test the matching of a Trigger based on provided event body
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<TestModeResults>> postProcessautomationTriggerTestAsync(ApiRequest<String> request, final AsyncApiCallback<ApiResponse<TestModeResults>> callback) {
    try {
      final SettableFuture<ApiResponse<TestModeResults>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<TestModeResults>() {}, new AsyncApiCallback<ApiResponse<TestModeResults>>() {
        @Override
        public void onCompleted(ApiResponse<TestModeResults> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<TestModeResults> response = (ApiResponse<TestModeResults>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<TestModeResults> response = (ApiResponse<TestModeResults>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Create a Trigger
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<Trigger> postProcessautomationTriggersAsync(PostProcessautomationTriggersRequest request, final AsyncApiCallback<Trigger> callback) {
    try {
      final SettableFuture<Trigger> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Trigger>() {}, new AsyncApiCallback<ApiResponse<Trigger>>() {
        @Override
        public void onCompleted(ApiResponse<Trigger> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Create a Trigger
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<Trigger>> postProcessautomationTriggersAsync(ApiRequest<CreateTriggerRequest> request, final AsyncApiCallback<ApiResponse<Trigger>> callback) {
    try {
      final SettableFuture<ApiResponse<Trigger>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<Trigger>() {}, new AsyncApiCallback<ApiResponse<Trigger>>() {
        @Override
        public void onCompleted(ApiResponse<Trigger> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<Trigger> response = (ApiResponse<Trigger>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<Trigger> response = (ApiResponse<Trigger>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Test the matching of all organization Triggers on given topic using provided event body
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<TestModeEventResults> postProcessautomationTriggersTopicTestAsync(PostProcessautomationTriggersTopicTestRequest request, final AsyncApiCallback<TestModeEventResults> callback) {
    try {
      final SettableFuture<TestModeEventResults> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<TestModeEventResults>() {}, new AsyncApiCallback<ApiResponse<TestModeEventResults>>() {
        @Override
        public void onCompleted(ApiResponse<TestModeEventResults> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Test the matching of all organization Triggers on given topic using provided event body
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<TestModeEventResults>> postProcessautomationTriggersTopicTestAsync(ApiRequest<String> request, final AsyncApiCallback<ApiResponse<TestModeEventResults>> callback) {
    try {
      final SettableFuture<ApiResponse<TestModeEventResults>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<TestModeEventResults>() {}, new AsyncApiCallback<ApiResponse<TestModeEventResults>>() {
        @Override
        public void onCompleted(ApiResponse<TestModeEventResults> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<TestModeEventResults> response = (ApiResponse<TestModeEventResults>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<TestModeEventResults> response = (ApiResponse<TestModeEventResults>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Update a Trigger
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<Trigger> putProcessautomationTriggerAsync(PutProcessautomationTriggerRequest request, final AsyncApiCallback<Trigger> callback) {
    try {
      final SettableFuture<Trigger> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Trigger>() {}, new AsyncApiCallback<ApiResponse<Trigger>>() {
        @Override
        public void onCompleted(ApiResponse<Trigger> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Update a Trigger
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<Trigger>> putProcessautomationTriggerAsync(ApiRequest<UpdateTriggerRequest> request, final AsyncApiCallback<ApiResponse<Trigger>> callback) {
    try {
      final SettableFuture<ApiResponse<Trigger>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<Trigger>() {}, new AsyncApiCallback<ApiResponse<Trigger>>() {
        @Override
        public void onCompleted(ApiResponse<Trigger> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<Trigger> response = (ApiResponse<Trigger>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<Trigger> response = (ApiResponse<Trigger>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }


  private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
    if (callback != null) {
      try {
        callback.onCompleted(result);
        future.set(result);
      }
      catch (Throwable exception) {
        future.setException(exception);
      }
    }
    else {
      future.set(result);
    }
  }

  private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
    if (callback != null) {
      try {
        callback.onFailed(exception);
        future.setException(exception);
      }
      catch (Throwable callbackException) {
        future.setException(callbackException);
      }
    }
    else {
      future.setException(exception);
    }
  }
}
