package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.model.*;
import com.mypurecloud.sdk.v2.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import com.mypurecloud.sdk.v2.model.CommandStatus;
import com.mypurecloud.sdk.v2.model.CommandStatusEntityListing;
import com.mypurecloud.sdk.v2.model.CreateShareRequest;
import com.mypurecloud.sdk.v2.model.CreateShareResponse;
import com.mypurecloud.sdk.v2.model.Document;
import com.mypurecloud.sdk.v2.model.DocumentEntityListing;
import com.mypurecloud.sdk.v2.model.DocumentUpdate;
import com.mypurecloud.sdk.v2.model.DocumentUpload;
import com.mypurecloud.sdk.v2.model.DownloadResponse;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.QueryRequest;
import com.mypurecloud.sdk.v2.model.QueryResults;
import com.mypurecloud.sdk.v2.model.ReplaceRequest;
import com.mypurecloud.sdk.v2.model.ReplaceResponse;
import com.mypurecloud.sdk.v2.model.SecurityProfile;
import com.mypurecloud.sdk.v2.model.SecurityProfileEntityListing;
import com.mypurecloud.sdk.v2.model.Share;
import com.mypurecloud.sdk.v2.model.ShareEntityListing;
import com.mypurecloud.sdk.v2.model.SharedResponse;
import com.mypurecloud.sdk.v2.model.TagQueryRequest;
import com.mypurecloud.sdk.v2.model.TagValue;
import com.mypurecloud.sdk.v2.model.TagValueEntityListing;
import com.mypurecloud.sdk.v2.model.Usage;
import com.mypurecloud.sdk.v2.model.Workspace;
import com.mypurecloud.sdk.v2.model.WorkspaceCreate;
import com.mypurecloud.sdk.v2.model.WorkspaceEntityListing;
import com.mypurecloud.sdk.v2.model.WorkspaceMember;
import com.mypurecloud.sdk.v2.model.WorkspaceMemberEntityListing;

public class GetContentmanagementSecurityprofileRequest {

	private String securityProfileId;
	public String getSecurityProfileId() {
		return this.securityProfileId;
	}

	public void setSecurityProfileId(String securityProfileId) {
		this.securityProfileId = securityProfileId;
	}

	public GetContentmanagementSecurityprofileRequest withSecurityProfileId(String securityProfileId) {
	    this.setSecurityProfileId(securityProfileId);
	    return this;
	} 

	private final Map<String, String> customHeaders = new HashMap<>();
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetContentmanagementSecurityprofileRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        
        // verify the required parameter 'securityProfileId' is set
        if (this.securityProfileId == null) {
            throw new IllegalStateException("Missing the required parameter 'securityProfileId' when building request for GetContentmanagementSecurityprofileRequest.");
        }
        

        return ApiRequestBuilder.create("GET", "/api/v2/contentmanagement/securityprofiles/{securityProfileId}")
                .withPathParameter("securityProfileId", securityProfileId)
        
		.withCustomHeaders(customHeaders)
                .withContentTypes("application/json")
                .withAccepts("application/json")
                .withAuthNames("PureCloud OAuth")
                .build();
    }

	public static Builder builder() {
		return new Builder();
	}


	public static Builder builder(String securityProfileId) {
	    return new Builder()
	            .withRequiredParams(securityProfileId);
	}


	public static class Builder {
		private final GetContentmanagementSecurityprofileRequest request;

		private Builder() {
			request = new GetContentmanagementSecurityprofileRequest();
		}


		public Builder withSecurityProfileId(String securityProfileId) {
			request.setSecurityProfileId(securityProfileId);
			return this;
		}



		public Builder withRequiredParams(String securityProfileId) {
			request.setSecurityProfileId(securityProfileId);

			return this;
		}


		public GetContentmanagementSecurityprofileRequest build() {
            
            // verify the required parameter 'securityProfileId' is set
            if (request.securityProfileId == null) {
                throw new IllegalStateException("Missing the required parameter 'securityProfileId' when building request for GetContentmanagementSecurityprofileRequest.");
            }
            
			return request;
		}
	}
}
