package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.BotMessengerProfile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * Humanize
 */

public class Humanize  implements Serializable {
  
  private Boolean enabled = null;
  private BotMessengerProfile bot = null;

  
  /**
   * Whether or not humanize conversations setting is enabled
   **/
  public Humanize enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Whether or not humanize conversations setting is enabled")
  @JsonProperty("enabled")
  public Boolean getEnabled() {
    return enabled;
  }
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  /**
   * Bot messenger profile setting
   **/
  public Humanize bot(BotMessengerProfile bot) {
    this.bot = bot;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Bot messenger profile setting")
  @JsonProperty("bot")
  public BotMessengerProfile getBot() {
    return bot;
  }
  public void setBot(BotMessengerProfile bot) {
    this.bot = bot;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Humanize humanize = (Humanize) o;

    return Objects.equals(this.enabled, humanize.enabled) &&
            Objects.equals(this.bot, humanize.bot);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, bot);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Humanize {\n");
    
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    bot: ").append(toIndentedString(bot)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

