/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A metric to measure within the chart")
public class JourneyViewChartMetric
implements Serializable {
    private String id = null;
    private String elementId = null;
    private AggregateEnum aggregate = null;

    public JourneyViewChartMetric id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The unique identifier of the metric within the chart")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JourneyViewChartMetric elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The element in the list of elements which the metric is measuring")
    @JsonProperty(value="elementId")
    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public JourneyViewChartMetric aggregate(AggregateEnum aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    @ApiModelProperty(example="null", value="How to aggregate the given element, defaults to EventCount")
    @JsonProperty(value="aggregate")
    public AggregateEnum getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(AggregateEnum aggregate) {
        this.aggregate = aggregate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewChartMetric journeyViewChartMetric = (JourneyViewChartMetric)o;
        return Objects.equals(this.id, journeyViewChartMetric.id) && Objects.equals(this.elementId, journeyViewChartMetric.elementId) && Objects.equals((Object)this.aggregate, (Object)journeyViewChartMetric.aggregate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.elementId, this.aggregate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewChartMetric {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    elementId: ").append(this.toIndentedString(this.elementId)).append("\n");
        sb.append("    aggregate: ").append(this.toIndentedString((Object)this.aggregate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AggregateEnumDeserializer.class)
    public static enum AggregateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EVENTCOUNT("EventCount"),
        CUSTOMERCOUNT("CustomerCount");

        private String value;

        private AggregateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AggregateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AggregateEnum value : AggregateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AggregateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AggregateEnumDeserializer
    extends StdDeserializer<AggregateEnum> {
        public AggregateEnumDeserializer() {
            super(AggregateEnumDeserializer.class);
        }

        public AggregateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AggregateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

