package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;

import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.model.*;
import com.mypurecloud.sdk.v2.Pair;

import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.AvailableTopicEntityListing;
import com.mypurecloud.sdk.v2.model.ChannelTopicEntityListing;
import com.mypurecloud.sdk.v2.model.ChannelEntityListing;
import com.mypurecloud.sdk.v2.model.ChannelTopic;
import com.mypurecloud.sdk.v2.model.Channel;


import com.mypurecloud.sdk.v2.api.request.DeleteNotificationsChannelSubscriptionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetNotificationsAvailabletopicsRequest;
import com.mypurecloud.sdk.v2.api.request.GetNotificationsChannelSubscriptionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetNotificationsChannelsRequest;
import com.mypurecloud.sdk.v2.api.request.PostNotificationsChannelSubscriptionsRequest;
import com.mypurecloud.sdk.v2.api.request.PostNotificationsChannelsRequest;
import com.mypurecloud.sdk.v2.api.request.PutNotificationsChannelSubscriptionsRequest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;


public class NotificationsApiAsync {
  private final ApiClient pcapiClient;

  public NotificationsApiAsync() {
    this(Configuration.getDefaultApiClient());
  }

  public NotificationsApiAsync(ApiClient apiClient) {
    this.pcapiClient = apiClient;
  }

  
  /**
   * Remove all subscriptions
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<Void> deleteNotificationsChannelSubscriptionsAsync(DeleteNotificationsChannelSubscriptionsRequest request, final AsyncApiCallback<Void> callback) {
    try {
      final SettableFuture<Void> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), null, new AsyncApiCallback<ApiResponse<Void>>() {
        @Override
        public void onCompleted(ApiResponse<Void> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Remove all subscriptions
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<Void>> deleteNotificationsChannelSubscriptionsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Void>> callback) {
    try {
      final SettableFuture<ApiResponse<Void>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, null, new AsyncApiCallback<ApiResponse<Void>>() {
        @Override
        public void onCompleted(ApiResponse<Void> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<Void> response = (ApiResponse<Void>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<Void> response = (ApiResponse<Void>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  
  /**
   * Get available notification topics.
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<AvailableTopicEntityListing> getNotificationsAvailabletopicsAsync(GetNotificationsAvailabletopicsRequest request, final AsyncApiCallback<AvailableTopicEntityListing> callback) {
    try {
      final SettableFuture<AvailableTopicEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<AvailableTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<AvailableTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<AvailableTopicEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Get available notification topics.
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<AvailableTopicEntityListing>> getNotificationsAvailabletopicsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<AvailableTopicEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<AvailableTopicEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<AvailableTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<AvailableTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<AvailableTopicEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<AvailableTopicEntityListing> response = (ApiResponse<AvailableTopicEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<AvailableTopicEntityListing> response = (ApiResponse<AvailableTopicEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  
  /**
   * The list of all subscriptions for this channel
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ChannelTopicEntityListing> getNotificationsChannelSubscriptionsAsync(GetNotificationsChannelSubscriptionsRequest request, final AsyncApiCallback<ChannelTopicEntityListing> callback) {
    try {
      final SettableFuture<ChannelTopicEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<ChannelTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelTopicEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * The list of all subscriptions for this channel
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<ChannelTopicEntityListing>> getNotificationsChannelSubscriptionsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<ChannelTopicEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<ChannelTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelTopicEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelTopicEntityListing> response = (ApiResponse<ChannelTopicEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelTopicEntityListing> response = (ApiResponse<ChannelTopicEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  
  /**
   * The list of existing channels
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ChannelEntityListing> getNotificationsChannelsAsync(GetNotificationsChannelsRequest request, final AsyncApiCallback<ChannelEntityListing> callback) {
    try {
      final SettableFuture<ChannelEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<ChannelEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * The list of existing channels
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<ChannelEntityListing>> getNotificationsChannelsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<ChannelEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<ChannelEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<ChannelEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelEntityListing> response = (ApiResponse<ChannelEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelEntityListing> response = (ApiResponse<ChannelEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  
  /**
   * Add a list of subscriptions to the existing list of subscriptions
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ChannelTopicEntityListing> postNotificationsChannelSubscriptionsAsync(PostNotificationsChannelSubscriptionsRequest request, final AsyncApiCallback<ChannelTopicEntityListing> callback) {
    try {
      final SettableFuture<ChannelTopicEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<ChannelTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelTopicEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Add a list of subscriptions to the existing list of subscriptions
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<ChannelTopicEntityListing>> postNotificationsChannelSubscriptionsAsync(ApiRequest<List<ChannelTopic>> request, final AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<ChannelTopicEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<ChannelTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelTopicEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelTopicEntityListing> response = (ApiResponse<ChannelTopicEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelTopicEntityListing> response = (ApiResponse<ChannelTopicEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  
  /**
   * Create a new channel
   * There is a limit of 5 channels per user/app combination. Creating a 6th channel will remove the channel with oldest last used date.
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<Channel> postNotificationsChannelsAsync(PostNotificationsChannelsRequest request, final AsyncApiCallback<Channel> callback) {
    try {
      final SettableFuture<Channel> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Channel>() {}, new AsyncApiCallback<ApiResponse<Channel>>() {
        @Override
        public void onCompleted(ApiResponse<Channel> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Create a new channel
   * There is a limit of 5 channels per user/app combination. Creating a 6th channel will remove the channel with oldest last used date.
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<Channel>> postNotificationsChannelsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Channel>> callback) {
    try {
      final SettableFuture<ApiResponse<Channel>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<Channel>() {}, new AsyncApiCallback<ApiResponse<Channel>>() {
        @Override
        public void onCompleted(ApiResponse<Channel> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<Channel> response = (ApiResponse<Channel>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<Channel> response = (ApiResponse<Channel>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  
  /**
   * Replace the current list of subscriptions with a new list.
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ChannelTopicEntityListing> putNotificationsChannelSubscriptionsAsync(PutNotificationsChannelSubscriptionsRequest request, final AsyncApiCallback<ChannelTopicEntityListing> callback) {
    try {
      final SettableFuture<ChannelTopicEntityListing> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<ChannelTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelTopicEntityListing> response) {
          notifySuccess(future, callback, response.getBody());
        }

        @Override
        public void onFailed(Throwable exception) {
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            notifySuccess(future, callback, null);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  /**
   * Replace the current list of subscriptions with a new list.
   * 
   * @param request the request object
   * @param callback the action to perform when the request is completed
   * @return the future indication when the request has completed
   */
  public Future<ApiResponse<ChannelTopicEntityListing>> putNotificationsChannelSubscriptionsAsync(ApiRequest<List<ChannelTopic>> request, final AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>> callback) {
    try {
      final SettableFuture<ApiResponse<ChannelTopicEntityListing>> future = SettableFuture.create();
      final boolean shouldThrowErrors = pcapiClient.getShouldThrowErrors();
      pcapiClient.invokeAsync(request, new TypeReference<ChannelTopicEntityListing>() {}, new AsyncApiCallback<ApiResponse<ChannelTopicEntityListing>>() {
        @Override
        public void onCompleted(ApiResponse<ChannelTopicEntityListing> response) {
          notifySuccess(future, callback, response);
        }

        @Override
        public void onFailed(Throwable exception) {
          if (exception instanceof ApiException) {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelTopicEntityListing> response = (ApiResponse<ChannelTopicEntityListing>)(ApiResponse<?>)exception;
            notifySuccess(future, callback, response);
          }
          if (shouldThrowErrors) {
            notifyFailure(future, callback, exception);
          }
          else {
            @SuppressWarnings("unchecked")
            ApiResponse<ChannelTopicEntityListing> response = (ApiResponse<ChannelTopicEntityListing>)(ApiResponse<?>)(new ApiException(exception));
            notifySuccess(future, callback, response);
          }
        }
      });
      return future;
    }
    catch (Throwable exception) {
      return Futures.immediateFailedFuture(exception);
    }
  }

  

  private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
    if (callback != null) {
      try {
        callback.onCompleted(result);
        future.set(result);
      }
      catch (Throwable exception) {
        future.setException(exception);
      }
    }
    else {
      future.set(result);
    }
  }

  private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
    if (callback != null) {
      try {
        callback.onFailed(exception);
        future.setException(exception);
      }
      catch (Throwable callbackException) {
        future.setException(callbackException);
      }
    }
    else {
      future.setException(exception);
    }
  }
}
